/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.PACKAGE;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class RandomAccessFile
extends AbstractRandomAccess {
    private static Logger Log = PACKAGE.Log;
    private java.io.RandomAccessFile fileAccess;
    private boolean readOnly = false;

    public RandomAccessFile(File file) throws IOException {
        this(file, true);
    }

    public RandomAccessFile(File file, boolean create) throws IOException {
        if (create && !file.exists()) {
            File dir = file.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            file.createNewFile();
        }
        if (!file.exists()) {
            throw new FileNotFoundException("file does not exist or can't be created");
        }
        if (file.canWrite()) {
            try {
                this.fileAccess = new java.io.RandomAccessFile(file, "rw");
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileAccess = new java.io.RandomAccessFile(file, "r");
        this.readOnly = true;
    }

    @Override
    public void close() throws IOException {
        if (this.fileAccess != null) {
            this.fileAccess.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.fileAccess.getChannel().force(true);
    }

    @Override
    public long getLength() throws IOException {
        return this.fileAccess.length();
    }

    @Override
    public long getOffset() throws IOException {
        return this.fileAccess.getFilePointer();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int read() throws IOException {
        return this.fileAccess.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.fileAccess.read(buffer);
    }

    @Override
    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        return this.fileAccess.read(buffer, start, numBytes);
    }

    @Override
    public void seek(long offset) throws IOException {
        this.fileAccess.seek(offset);
    }

    @Override
    public void seekBy(long delta) throws IOException {
        this.seek(this.fileAccess.getFilePointer() + delta);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.fileAccess.setLength(newLength);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.fileAccess.write(buffer);
    }

    @Override
    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        this.fileAccess.write(buffer, start, numBytes);
    }

    @Override
    public void write(int b) throws IOException {
        this.fileAccess.write(b);
    }
}

