/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessFilter;
import java.io.IOException;

public class RandomAccessViewport
extends RandomAccessFilter {
    private final long viewOffset;
    private long viewLength;
    private long viewEnd;

    public RandomAccessViewport(IRandomAccess ra, long offset, long length) throws IOException {
        super(ra);
        this.viewLength = length;
        this.viewOffset = offset;
        this.viewEnd = this.viewOffset + this.viewLength;
    }

    @Override
    public long getLength() throws IOException {
        long realLength = this.getRandom().getLength();
        if (this.getViewLength() == -1L) {
            return realLength - this.getViewOffset();
        }
        return Math.min(this.getViewLength(), realLength - this.getViewOffset());
    }

    @Override
    public long getOffset() throws IOException {
        return this.getRandom().getOffset() - this.getViewOffset();
    }

    protected long getViewEnd() {
        return this.viewEnd;
    }

    protected long getViewLength() {
        return this.viewLength;
    }

    protected long getViewOffset() {
        return this.viewOffset;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.getViewLength() != -1L && this.getOffset() >= this.getViewEnd()) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        if (this.getViewLength() != -1L && this.getOffset() >= this.getViewEnd()) {
            return -1;
        }
        if (this.getViewLength() != -1L) {
            numBytes = Math.min(numBytes, (int)(this.getViewEnd() - this.getOffset()));
        }
        return super.read(buffer, start, numBytes);
    }

    @Override
    public void seek(long offset) throws IOException {
        super.seek(this.getViewOffset() + offset);
    }

    @Override
    public void seekBy(long delta) throws IOException {
        super.seekBy(delta);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        throw new IOException("not yet supported");
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        super.write(buffer);
    }

    @Override
    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        super.write(buffer, start, numBytes);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }
}

