/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.range;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.number.NumberWrapper;
import de.intarsys.tools.range.DefinedRange;
import de.intarsys.tools.range.EnumRange;
import de.intarsys.tools.range.IRange;
import de.intarsys.tools.range.NamedRange;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.List;

public class RangeTools {
    public static IRange getRange(IArgs args, String argName, IRange defaultValue) {
        Object optionValue = args.get(argName);
        if (optionValue == null) {
            return defaultValue;
        }
        return RangeTools.toRange(optionValue);
    }

    public static IRange toRange(Object object) {
        if (object instanceof IRange) {
            return (IRange)object;
        }
        if (object instanceof NumberWrapper) {
            return new DefinedRange((NumberWrapper)object);
        }
        if (object instanceof Integer) {
            return DefinedRange.create((Integer)object);
        }
        if (object instanceof List) {
            return DefinedRange.create((List)object);
        }
        if (object instanceof String) {
            String stringValue = (String)object;
            if (StringTools.isNumeric(stringValue)) {
                try {
                    return DefinedRange.create(stringValue);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("range");
                }
            }
            EnumRange rangeItem = (EnumRange)EnumRange.META.getItemOrDefault(stringValue);
            return new NamedRange(rangeItem);
        }
        throw new IllegalArgumentException("range");
    }
}

