/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import de.intarsys.tools.reader.UnEscapeReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class DirectTagReader
extends FilterReader {
    private static final char[] defaultEndTag = "}".toCharArray();
    public static final Map DefaultEscapeMap = new HashMap();
    private static final char[] defaultStartTag = "${".toCharArray();
    public static final char ESCAPE_CHARACTER = '\\';
    private static ILocationProvider nullLocationProvider = new NullLocationProvider();
    private static final Object UNUSED = new Object();
    private int bufferLength = 0;
    private int checkLength = 0;
    private Object context;
    private char[] endTag = defaultEndTag;
    private boolean forceToString = true;
    private IDirectTagHandler handler;
    private char[] readBuffer = new char[100];
    private Object resolvedObject = UNUSED;
    private char[] startTag = defaultStartTag;
    private StringBuilder tagBuffer = new StringBuilder();
    private UnEscapeReader unescapeReader;

    static {
        DefaultEscapeMap.put(new Character('\\'), new Character('\\'));
        DefaultEscapeMap.put(new Character('n'), new Character('\n'));
        DefaultEscapeMap.put(new Character('r'), new Character('\r'));
        DefaultEscapeMap.put(new Character('t'), new Character('\t'));
        DefaultEscapeMap.put(new Character('$'), new Character('$'));
        DefaultEscapeMap.put(new Character('}'), new Character('}'));
        DefaultEscapeMap.put(new Character('\n'), null);
        DefaultEscapeMap.put(new Character('\r'), null);
        DefaultEscapeMap.put(new Character('\t'), null);
        DefaultEscapeMap.put(new Character(' '), null);
    }

    public static String escape(String value) {
        return value.replaceAll("\\$\\{", "\\$\\{\\$\\{\\}");
    }

    public DirectTagReader(Reader pReader, IDirectTagHandler handler, Object context) {
        this(pReader, handler, context, true);
    }

    public DirectTagReader(Reader pReader, IDirectTagHandler handler, Object context, boolean escape) {
        super(pReader);
        if (escape) {
            this.in = new UnEscapeReader(pReader, '\\', DefaultEscapeMap);
            this.unescapeReader = (UnEscapeReader)this.in;
        }
        this.handler = handler;
        this.context = context;
        if (pReader instanceof ILocationProvider) {
            handler.setLocationProvider((ILocationProvider)((Object)pReader));
        } else {
            handler.setLocationProvider(nullLocationProvider);
        }
    }

    protected int basicRead() throws IOException {
        if (this.bufferLength > 0) {
            return this.readBuffer[--this.bufferLength];
        }
        this.checkLength = Integer.MAX_VALUE;
        return super.read();
    }

    protected IDirectTagHandler getHandler() {
        return this.handler;
    }

    public Object getResolvedObject() {
        if (this.resolvedObject == UNUSED) {
            return null;
        }
        return this.resolvedObject;
    }

    public boolean hasResolvedObject() {
        return this.resolvedObject != UNUSED;
    }

    public boolean isForceToString() {
        return this.forceToString;
    }

    protected boolean isSpecialTag(String tag) {
        if (tag.length() == this.startTag.length) {
            int index = 0;
            while (index < this.startTag.length) {
                if (tag.charAt(index) != this.startTag[index]) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        int i = this.basicRead();
        if (!(this.checkLength <= this.bufferLength || i != this.startTag[0] || this.unescapeReader != null && this.unescapeReader.isMapped())) {
            return this.scanTag();
        }
        this.forceToString = true;
        return i;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
            ++i;
        }
        return len;
    }

    protected int scanEndTag() throws IOException {
        int tagIndex = 0;
        int i = this.endTag[0];
        while (i == this.endTag[tagIndex]) {
            if (++tagIndex == this.endTag.length) {
                return -1;
            }
            i = this.basicRead();
        }
        if (i != -1) {
            this.unread(i);
        }
        this.unread(this.endTag, 0, tagIndex);
        return this.basicRead();
    }

    protected int scanTag() throws IOException {
        int tagIndex = 0;
        int i = this.startTag[0];
        while (i == this.startTag[tagIndex]) {
            if (++tagIndex == this.startTag.length) {
                this.handler.startTag();
                return this.scanTagContent();
            }
            i = this.basicRead();
        }
        if (i != -1) {
            this.unread(i);
        }
        this.unread(this.startTag, 0, tagIndex);
        return this.basicRead();
    }

    protected int scanTagContent() throws IOException {
        this.tagBuffer.setLength(0);
        int i = this.tagRead();
        while (i != -1) {
            this.tagBuffer.append((char)i);
            i = this.tagRead();
        }
        String tag = this.tagBuffer.toString();
        this.resolvedObject = this.isSpecialTag(tag) ? tag : this.getHandler().endTag(tag, this.context);
        if (!this.forceToString && !(this.resolvedObject instanceof String)) {
            i = this.basicRead();
            if (i != -1) {
                this.unread(i);
            } else {
                return -1;
            }
        }
        this.forceToString = true;
        if (this.resolvedObject != null) {
            String tempString = String.valueOf(this.resolvedObject);
            this.checkLength = this.bufferLength;
            this.unread(tempString.toCharArray(), 0, tempString.length());
        }
        return this.read();
    }

    public void setEndTag(String tag) {
        if (this.endTag != null && this.unescapeReader != null) {
            this.unescapeReader.removeEscapedCharacter(this.endTag[0]);
        }
        this.endTag = tag.toCharArray();
        if (this.unescapeReader != null) {
            this.unescapeReader.addEscapedCharacter(this.endTag[0], this.endTag[0]);
        }
    }

    public void setForceToString(boolean forceToString) {
        this.forceToString = forceToString;
    }

    public void setResolvedObject(Object resolvedObject) {
        this.resolvedObject = resolvedObject;
    }

    public void setStartTag(String tag) {
        if (this.startTag != null && this.unescapeReader != null) {
            this.unescapeReader.removeEscapedCharacter(this.startTag[0]);
        }
        this.startTag = tag.toCharArray();
        if (this.unescapeReader != null) {
            this.unescapeReader.addEscapedCharacter(this.startTag[0], this.startTag[0]);
        }
    }

    protected int tagRead() throws IOException {
        int i = super.read();
        if (i == -1) {
            throw new IOException("end tag '" + new String(this.endTag) + "' missing");
        }
        if (!(i != this.endTag[0] || this.unescapeReader != null && this.unescapeReader.isMapped())) {
            return this.scanEndTag();
        }
        return i;
    }

    protected void unread(char[] chars, int start, int len) {
        if (this.readBuffer.length < this.bufferLength + len) {
            char[] newBuffer = new char[(this.bufferLength + len) * 2];
            System.arraycopy(this.readBuffer, 0, newBuffer, 0, this.bufferLength);
            this.readBuffer = newBuffer;
        }
        int i = start + len - 1;
        while (i >= start) {
            this.readBuffer[this.bufferLength++] = chars[i];
            --i;
        }
    }

    protected void unread(int c) {
        if (this.readBuffer.length < this.bufferLength + 1) {
            char[] newBuffer = new char[(this.bufferLength + 1) * 2];
            System.arraycopy(this.readBuffer, 0, newBuffer, 0, this.bufferLength);
            this.readBuffer = newBuffer;
        }
        this.readBuffer[this.bufferLength++] = (char)c;
    }

    private static class NullLocationProvider
    implements ILocationProvider {
        private NullLocationProvider() {
        }

        @Override
        public int getColumn() {
            return 0;
        }

        @Override
        public int getLine() {
            return 0;
        }

        @Override
        public int getPosition() {
            return 0;
        }
    }
}

