/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ClassLoaderTools {
    public static ClassLoader createClassLoader(ClassLoader parent, File baseDir, String classpath, String classpathScan, String classpathScanExclude) {
        URL[] urlArray = ClassLoaderTools.createURLs(baseDir, classpath, classpathScan, classpathScanExclude);
        URLClassLoader classLoader = new URLClassLoader(urlArray, parent);
        return classLoader;
    }

    public static void createURL(List<URL> urls, File file) {
        if (file.isFile()) {
            try {
                urls.add(new URL("file", "", file.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                urls.add(new URL("file", "", String.valueOf(file.getAbsolutePath()) + "/"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static URL[] createURLs(File baseDir, String classpath, String classpathScan, String classpathScanExclude) {
        int n;
        String[] names;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!StringTools.isEmpty(classpath)) {
            String[] stringArray = names = classpath.split(";");
            n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.createURL(urls, file);
                ++n2;
            }
        }
        if (!StringTools.isEmpty(classpathScan)) {
            names = classpathScan.split(";");
            List<Object> exclude = StringTools.isEmpty(classpathScanExclude) ? new ArrayList() : Arrays.asList(classpathScanExclude.split(";"));
            String[] stringArray = names;
            int n3 = names.length;
            n = 0;
            while (n < n3) {
                String name = stringArray[n];
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.createURLScanJar(urls, file, exclude);
                ++n;
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return urlArray;
    }

    public static URL[] createURLs(URL codebase, String classpath, boolean relativeOnly) throws IOException {
        String codebaseString = codebase.toString();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!StringTools.isEmpty(classpath)) {
            StringTokenizer st = new StringTokenizer(classpath, ";");
            while (st.hasMoreElements()) {
                String name = st.nextToken();
                URL newUrl = new URL(codebase, name.trim());
                if (relativeOnly && !newUrl.toString().startsWith(codebaseString)) {
                    throw new IOException("url " + newUrl + " not relative to " + codebaseString);
                }
                urls.add(newUrl);
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return urlArray;
    }

    public static void createURLScanJar(List<URL> result, File directory, final List<String> exclude) {
        File[] jarFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isFile() && path.canRead() && path.getName().toLowerCase().endsWith(".jar") && !exclude.contains(path.getName());
            }
        });
        if (jarFiles != null) {
            File[] fileArray = jarFiles;
            int n = jarFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    result.add(new URL("file", "", file.getAbsolutePath()));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public static void extendClassLoader(ClassLoader classLoader, URL url) {
        try {
            Method addUrl;
            try {
                addUrl = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            }
            catch (Exception e) {
                addUrl = classLoader.getClass().getDeclaredMethod("addAppURL", URL.class);
            }
            addUrl.setAccessible(true);
            addUrl.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

