/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassTools {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public static List collectClasses(String classPath) throws IOException {
        List classNames = ClassTools.collectClassNames(classPath);
        ClassLoader loader = ClassTools.createClassLoader(classPath);
        ArrayList classes = new ArrayList();
        for (String className : classNames) {
            try {
                classes.add(loader.loadClass(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }

    public static List collectClassNames(String classPath) throws IOException {
        ArrayList classnames = new ArrayList();
        StringTokenizer path = new StringTokenizer(classPath, PATH_SEPARATOR);
        int pathCount = path.countTokens();
        int ii = 0;
        while (ii < pathCount) {
            String currentName = path.nextToken();
            File currentFile = new File(currentName);
            if (currentFile.isFile()) {
                ClassTools.extractClassNamesFromJar(classnames, currentFile);
            } else {
                ClassTools.extractClassNamesFromDir(classnames, currentFile, "");
            }
            ++ii;
        }
        return classnames;
    }

    public static <T> Class<T> createClass(String className, Class<T> expectedClass, ClassLoader classLoader) throws ObjectCreationException {
        if (StringTools.isEmpty(className)) {
            throw new ObjectCreationException("class name missing");
        }
        className = className.trim();
        try {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = expectedClass == null ? ClassTools.class.getClassLoader() : expectedClass.getClassLoader();
            }
            Class<?> clazz = Class.forName(className, false, classLoader);
            if (expectedClass != null && !expectedClass.isAssignableFrom(clazz)) {
                throw new ObjectCreationException("class '" + clazz.getName() + "' not compatible with expected type '" + expectedClass + "'");
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ObjectCreationException("class '" + className + "' not found", (Throwable)e);
        }
        catch (Throwable e) {
            throw new ObjectCreationException("class '" + className + "' not found", e);
        }
    }

    public static ClassLoader createClassLoader(String classPath) {
        URL[] allURLs = null;
        StringTokenizer path = new StringTokenizer(classPath, PATH_SEPARATOR);
        int i = path.countTokens();
        allURLs = new URL[i + 1];
        int ii = 0;
        while (ii < i) {
            String currentPath = path.nextToken();
            try {
                URL url;
                allURLs[ii] = url = new URL("file", "", currentPath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++ii;
        }
        URLClassLoader loader = URLClassLoader.newInstance(allURLs);
        return loader;
    }

    protected static void extractClassNamesFromDir(List result, File currentFile, String relativePath) throws IOException {
        if (currentFile.isFile()) {
            String filename = currentFile.getName();
            if (filename.endsWith(".class")) {
                String className = filename.substring(0, filename.length() - 6);
                result.add(String.valueOf(relativePath) + className);
            }
        } else {
            String[] allFiles = currentFile.list();
            if (allFiles == null) {
                throw new IOException("error creating directory listing for " + currentFile.getAbsolutePath());
            }
            int i = 0;
            while (i < allFiles.length) {
                File child = new File(currentFile, allFiles[i]);
                ClassTools.extractClassNamesFromDir(result, child, String.valueOf(relativePath) + allFiles[i] + ".");
                ++i;
            }
        }
    }

    protected static void extractClassNamesFromJar(List result, File file) throws IOException {
        try (JarFile jar = null;){
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                className = className.replace('/', '.');
                result.add(className);
            }
        }
    }

    public static String getPackageName(Class clazz) {
        String name = clazz.getName();
        return ClassTools.getPackageName(name);
    }

    public static String getPackageName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public static String getUnqualifiedName(Class clazz) {
        String name = clazz.getName();
        return ClassTools.getUnqualifiedName(name);
    }

    public static String getUnqualifiedName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    private ClassTools() {
    }
}

