/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import de.intarsys.tools.reflect.IBasicInvocationSupport;
import de.intarsys.tools.reflect.IBasicRegistrySupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ObjectTools {
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private static final Class[] EMPTY_PARAMETERTYPES = new Class[0];
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private static final Map<Class, Class> PRIMITIVE_WRAPPER = new HashMap<Class, Class>();

    static {
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("bool", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER.put(Void.TYPE, Void.class);
        PRIMITIVE_WRAPPER.put(Short.TYPE, Short.class);
    }

    public static Object basicGet(Object object, String name) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicGetValue(name);
        }
        try {
            Method method = ObjectTools.findGetter(object, name);
            return method.invoke(object, null);
        }
        catch (Exception method) {
            try {
                Field field = object.getClass().getField(name);
                return field.get(object);
            }
            catch (Exception field) {
                try {
                    Method method2 = object.getClass().getMethod(name, null);
                    return method2.invoke(object, null);
                }
                catch (Exception e) {
                    throw new FieldAccessException(object.getClass(), name, (Throwable)e);
                }
            }
        }
    }

    public static Object basicInsert(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        try {
            Method method = ObjectTools.findInserter(object, name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).add(value)) {
                    return value;
                }
                return null;
            }
            throw new FieldAccessException(object.getClass(), name, "can't insert in " + name);
        }
    }

    public static Object basicInvoke(Object object, String name, Object ... values) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        if (object instanceof IBasicInvocationSupport) {
            return ((IBasicInvocationSupport)object).basicInvoke(name, values);
        }
        Method method = ObjectTools.findMethod(object, name, values);
        try {
            return method.invoke(object, values);
        }
        catch (Exception e) {
            throw new MethodInvocationException(object.getClass(), name, (Throwable)e);
        }
    }

    public static Object basicRemove(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        try {
            Method method = ObjectTools.findRemover(object, name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).remove(value)) {
                    return value;
                }
                return null;
            }
            throw new FieldAccessException(object.getClass(), name, "can't remove from " + name);
        }
    }

    public static Object basicSet(Object object, String name, Object value) throws FieldException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicSetValue(name, value);
        }
        try {
            Method method = ObjectTools.findSetter(object, name, value);
            return method.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException(object.getClass(), name, e.getCause());
        }
        catch (Exception e) {
            try {
                Field field = object.getClass().getField(name);
                Object oldValue = field.get(object);
                field.set(object, value);
                return oldValue;
            }
            catch (Exception e2) {
                throw new FieldAccessException(object.getClass(), name, (Throwable)e2);
            }
        }
    }

    protected static boolean checkCandidate(Method method, String methodName, Class[] pClasses) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        Class[] mClasses = method.getParameterTypes();
        return ObjectTools.checkCandidateClasses(mClasses, pClasses);
    }

    protected static boolean checkCandidateClasses(Class[] mClasses, Class[] pClasses) {
        if (mClasses.length != pClasses.length) {
            return false;
        }
        int i = 0;
        while (i < mClasses.length) {
            if (!ObjectTools.isAssignable(mClasses[i], pClasses[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Object convert(Object value, String typeName, ClassLoader classLoader) throws ObjectCreationException {
        if (typeName == null) {
            return value;
        }
        Class<Object> type = ClassTools.createClass(typeName, Object.class, classLoader);
        try {
            return ConverterRegistry.get().convert(value, type);
        }
        catch (ConversionException e) {
            throw new ObjectCreationException(e);
        }
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, expectedClass, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass, Class[] parameterTypes, Object[] parameters) throws ObjectCreationException {
        if (clazz == null) {
            throw new ObjectCreationException("class missing");
        }
        try {
            Object object;
            if (parameters == EMPTY_PARAMETERS) {
                object = clazz.newInstance();
            } else {
                Constructor constructor = clazz.getConstructor(parameterTypes);
                object = constructor.newInstance(parameters);
            }
            if (object instanceof IInitializeable) {
                ((IInitializeable)object).initializeAfterCreation();
            }
            return object;
        }
        catch (NoClassDefFoundError e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
        catch (Exception e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", (Throwable)e);
        }
    }

    public static <T> T createObject(String className, Class<T> expectedClass, ClassLoader classLoader) throws ObjectCreationException {
        Class<T> clazz = ClassTools.createClass(className, expectedClass, classLoader);
        return ObjectTools.createObject(clazz, expectedClass);
    }

    public static Method findGetter(Object object, String name) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        try {
            String methodName = GET_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            return object.getClass().getMethod(methodName, null);
        }
        catch (Exception methodName) {
            String methodName2 = IS_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                return object.getClass().getMethod(methodName2, null);
            }
            catch (Exception e) {
                throw new MethodNotFoundException(object.getClass(), name);
            }
        }
    }

    public static Method findInserter(Object object, String attribute, Object value) throws MethodException {
        Method result;
        try {
            String methodName = "add" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
            result = ObjectTools.findMethod(object, methodName, value);
        }
        catch (Exception e) {
            try {
                String methodName = "insert" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
                result = ObjectTools.findMethod(object, methodName, value);
            }
            catch (Exception e2) {
                String methodName = "register" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
                result = ObjectTools.findMethod(object, methodName, value);
            }
        }
        return result;
    }

    protected static Method findMatchingMethod(Class clazz, String name, Class[] classes) throws MethodException {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (ObjectTools.checkCandidate(method, name, classes)) {
                return method;
            }
            ++i;
        }
        try {
            return clazz.getMethod(name, classes);
        }
        catch (Exception e) {
            throw new MethodNotFoundException(clazz, name);
        }
    }

    public static Method findMethod(Object object, String methodName, Object ... parameters) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        Class<?> clazz = object.getClass();
        Class[] parameterClasses = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            parameterClasses[i] = parameters[i].getClass();
            ++i;
        }
        Method method = null;
        try {
            method = ObjectTools.findMethodFast(clazz, methodName, parameterClasses);
        }
        catch (Exception e) {
            method = ObjectTools.findMethodNamed(clazz, methodName, false, parameterClasses);
        }
        return method;
    }

    protected static Method findMethodFast(Class clazz, String name, Class ... classes) throws MethodException {
        try {
            return clazz.getMethod(name, classes);
        }
        catch (Exception e) {
            throw new MethodNotFoundException(clazz, name);
        }
    }

    protected static Method findMethodNamed(Class clazz, String name, boolean wildcard, Class ... classes) throws MethodException {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (!(wildcard ? !method.getName().startsWith(name) : !method.getName().equals(name))) {
                boolean found = true;
                Class<?>[] parameterTypes = method.getParameterTypes();
                int j = 0;
                while (j < parameterTypes.length) {
                    Class<?> parameterType = parameterTypes[j];
                    Class searchType = classes[j];
                    if (!ObjectTools.isAssignable(parameterType, searchType)) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return method;
                }
            }
            ++i;
        }
        throw new MethodNotFoundException(clazz, name);
    }

    public static Method findMethodPrefixed(Object object, String methodPrefix, Object ... parameters) throws MethodException {
        if (object == null) {
            throw new NullPointerException("object can't be null");
        }
        Class<?> clazz = object.getClass();
        Class[] parameterClasses = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            parameterClasses[i] = parameters[i].getClass();
            ++i;
        }
        Method method = null;
        method = ObjectTools.findMethodNamed(clazz, methodPrefix, true, parameterClasses);
        return method;
    }

    public static Method findRegister(Object object, Object value) throws MethodException {
        String methodPrefix = "register";
        return ObjectTools.findMethodPrefixed(object, methodPrefix, value);
    }

    public static Method findRemover(Object object, String attribute, Object value) throws MethodException {
        String methodName = "remove" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(object, methodName, value);
    }

    public static Method findSetter(Object object, String attribute, Object value) throws MethodException {
        String methodName = "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(object, methodName, value);
    }

    public static Object get(Object object, String name) throws FieldException {
        String tempExpr = name;
        int pos = tempExpr.indexOf(46);
        if (pos == -1) {
            return ObjectTools.basicGet(object, name);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.get(result, pathTrail);
    }

    public static Object insert(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name;
        if (tempExpr.indexOf(91) >= 0) {
            tempExpr = name.replace('[', '.');
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicInsert(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.insert(result, pathTrail, value);
    }

    public static Object invoke(Object object, String name, Object ... values) throws MethodException {
        Object result;
        int pos;
        String tempExpr = name;
        if (tempExpr.indexOf(91) >= 0) {
            tempExpr = name.replace('[', '.');
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicInvoke(object, name, values);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        try {
            result = ObjectTools.basicGet(object, pathPrefix);
        }
        catch (FieldException e) {
            throw new MethodInvocationException(object.getClass(), name, (Throwable)e);
        }
        return ObjectTools.invoke(result, pathTrail, values);
    }

    public static boolean isAssignable(Class target, Class source) {
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (target.isPrimitive()) {
            return PRIMITIVE_WRAPPER.get(target).isAssignableFrom(source);
        }
        if (source.isPrimitive()) {
            return target.isAssignableFrom(PRIMITIVE_WRAPPER.get(source));
        }
        return false;
    }

    public static Object register(Object registry, Object value) throws MethodException {
        if (registry instanceof IBasicRegistrySupport) {
            return ((IBasicRegistrySupport)registry).basicRegister(value);
        }
        Method method = ObjectTools.findRegister(registry, value);
        try {
            return method.invoke(registry, value);
        }
        catch (Exception e) {
            throw new MethodInvocationException(registry.getClass(), "register", e.getCause());
        }
    }

    public static Object remove(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name;
        if (tempExpr.indexOf(91) >= 0) {
            tempExpr = name.replace('[', '.');
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicRemove(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.remove(result, pathTrail, value);
    }

    public static Object set(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name;
        if (tempExpr.indexOf(91) >= 0) {
            tempExpr = name.replace('[', '.');
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicSet(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.set(result, pathTrail, value);
    }
}

