/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.reflect.RelationHandlerAdapter;
import java.lang.reflect.Method;
import java.util.Collection;

public class ReflectionRelationHandler
extends RelationHandlerAdapter {
    private final Method getter;
    private final Method inserter;
    private final Method remover;

    public ReflectionRelationHandler(Method getter, Method inserter, Method remover) {
        this.getter = getter;
        this.inserter = inserter;
        this.remover = remover;
    }

    @Override
    public Object[] get(Object owner) {
        try {
            Object value = this.getter.invoke(owner, null);
            if (value instanceof Collection) {
                return ((Collection)value).toArray();
            }
            if (value instanceof Object[]) {
                return (Object[])value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Object[0];
    }

    @Override
    public Object insert(Object owner, Object value) {
        try {
            return this.inserter.invoke(owner, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object remove(Object owner, Object value) {
        try {
            return this.remover.invoke(owner, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int size(Object owner) {
        try {
            Object value = this.getter.invoke(owner, null);
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            if (value instanceof Object[]) {
                return ((Object[])value).length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public Object update(Object owner, Object value, Object newValue) {
        try {
            this.remover.invoke(owner, value);
            return this.inserter.invoke(owner, newValue);
        }
        catch (Exception e) {
            return null;
        }
    }
}

