/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.reporter.IReporter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultReporter
implements IReporter {
    private final Logger logger;

    public DefaultReporter() {
        this(LogTools.getLogger(DefaultReporter.class));
    }

    public DefaultReporter(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void reportActivityEnd() {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "end activity ");
        }
    }

    @Override
    public void reportActivityStart(String activity, int style) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "start activity " + activity);
        }
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        this.getLogger().log(Level.SEVERE, message, t);
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        this.getLogger().log(Level.INFO, message);
    }

    @Override
    public void reportProgress(String text, int percent, int style) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, String.valueOf(text) + " [" + percent + "%]");
        }
    }

    @Override
    public void reportStatus(String text, int style) {
        this.getLogger().log(Level.INFO, text);
    }
}

