/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReportDispatcher;
import de.intarsys.tools.reporter.ReportEvent;

public class ReplayReporter
implements IReporter,
IReporterSupport {
    private final Object owner;
    private final ReportDispatcher dispatcher;
    private final ReportEvent[] messages = new ReportEvent[10];
    private int first = 0;

    public ReplayReporter(Object owner) {
        this.owner = owner;
        this.dispatcher = new ReportDispatcher(owner);
    }

    protected void addMessage(ReportEvent message) {
        this.messages[this.first] = message;
        this.first = (this.first + 1) % this.messages.length;
    }

    @Override
    public void addReporter(IReporter reporter) {
        this.dispatcher.addReporter(reporter);
        this.replay(reporter);
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void removeReporter(IReporter reporter) {
        this.dispatcher.removeReporter(reporter);
    }

    protected void replay(IReporter reporter) {
        int i = 0;
        while (i < this.messages.length) {
            int index = (i + this.first) % this.messages.length;
            ReportEvent message = this.messages[index];
            if (message != null) {
                if (message.isTypeStatus()) {
                    reporter.reportStatus(message.getMessage(), message.getStyle());
                } else if (message.isTypeMessage()) {
                    reporter.reportMessage(message.getTitle(), message.getMessage(), message.getStyle());
                } else if (message.isTypeError()) {
                    reporter.reportError(message.getTitle(), message.getMessage(), message.getThrowable(), message.getStyle());
                }
            }
            ++i;
        }
    }

    @Override
    public void reportActivityEnd() {
        this.addMessage(new ReportEvent(2));
        this.dispatcher.reportActivityEnd();
    }

    @Override
    public void reportActivityStart(String activity, int style) {
        this.addMessage(new ReportEvent(1, activity, style));
        this.dispatcher.reportActivityStart(activity, style);
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        this.addMessage(new ReportEvent(5, title, message, t, style));
        this.dispatcher.reportError(title, message, t, style);
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        this.addMessage(new ReportEvent(4, title, message, style));
        this.dispatcher.reportMessage(title, message, style);
    }

    @Override
    public void reportProgress(String message, int percent, int style) {
        this.addMessage(new ReportEvent(0, message, percent, style));
        this.dispatcher.reportProgress(message, percent, style);
    }

    @Override
    public void reportStatus(String message, int style) {
        this.addMessage(new ReportEvent(3, message, style));
        this.dispatcher.reportStatus(message, style);
    }
}

