/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;

public class ReportDispatcher
implements IReporterSupport,
IReporter {
    private final Object owner;
    private IReporter[] reporters = new IReporter[2];

    public ReportDispatcher(Object pOwner) {
        this.owner = pOwner;
    }

    @Override
    public synchronized void addReporter(IReporter newReporter) {
        if (newReporter == null) {
            throw new NullPointerException("reporter may not be null");
        }
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            if (this.reporters[i] == null) break;
            ++i;
        }
        if (i >= length) {
            IReporter[] tempReporters = new IReporter[length + 4];
            System.arraycopy(this.reporters, 0, tempReporters, 0, length);
            this.reporters = tempReporters;
        }
        this.reporters[i] = newReporter;
    }

    public synchronized void attach(IReporterSupport support) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            support.addReporter(this.reporters[i]);
            ++i;
        }
    }

    public synchronized void clear() {
        this.reporters = new IReporter[4];
    }

    public synchronized void detach(IReporterSupport support) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            support.removeReporter(this.reporters[i]);
            ++i;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized boolean isEmpty() {
        int i = 0;
        while (i < this.reporters.length) {
            if (this.reporters[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public synchronized void removeReporter(IReporter newReporter) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            if (this.reporters[i] == newReporter) {
                this.reporters[i] = null;
                break;
            }
            ++i;
        }
    }

    @Override
    public void reportActivityEnd() {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportActivityEnd();
            }
            ++i;
        }
    }

    @Override
    public void reportActivityStart(String message, int style) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportActivityStart(message, style);
            }
            ++i;
        }
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportError(title, message, t, style);
            }
            ++i;
        }
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportMessage(title, message, style);
            }
            ++i;
        }
    }

    @Override
    public void reportProgress(String message, int percent, int style) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportProgress(message, percent, style);
            }
            ++i;
        }
    }

    @Override
    public void reportStatus(String message, int style) {
        int length = this.reporters.length;
        int i = 0;
        while (i < length) {
            IReporter tempReporter = this.reporters[i];
            if (tempReporter != null) {
                tempReporter.reportStatus(message, style);
            }
            ++i;
        }
    }
}

