/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

public class ReportEvent {
    public static final int TYPE_ACTIVITY_END = 2;
    public static final int TYPE_ACTIVITY_START = 1;
    public static final int TYPE_ERROR = 5;
    public static final int TYPE_MESSAGE = 4;
    public static final int TYPE_PROGRESS = 0;
    public static final int TYPE_STATUS = 3;
    private final int style;
    private final Throwable throwable;
    private final String title;
    private final int type;
    private final Thread thread;
    private String message;
    private int percent;
    private int index;
    private Object data;

    public ReportEvent(int type) {
        this.type = type;
        this.index = 0;
        this.message = null;
        this.thread = Thread.currentThread();
        this.title = null;
        this.throwable = null;
        this.style = 0;
    }

    public ReportEvent(int type, String message, int style) {
        this.type = type;
        this.index = 0;
        this.message = message;
        this.thread = Thread.currentThread();
        this.title = null;
        this.throwable = null;
        this.style = style;
    }

    public ReportEvent(int type, String message, int percent, int style) {
        this.type = type;
        this.index = 0;
        this.message = message;
        this.percent = percent;
        if (percent > 0) {
            ++this.index;
        }
        this.thread = Thread.currentThread();
        this.title = null;
        this.throwable = null;
        this.style = style;
    }

    public ReportEvent(int type, String title, String message, int style) {
        this.type = type;
        this.index = 0;
        this.message = message;
        this.thread = Thread.currentThread();
        this.title = title;
        this.throwable = null;
        this.style = style;
    }

    public ReportEvent(int type, String title, String message, Throwable t, int style) {
        this.type = type;
        this.index = 0;
        this.message = message;
        this.thread = Thread.currentThread();
        this.title = title;
        this.throwable = t;
        this.style = style;
    }

    public Object getData() {
        return this.data;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPercent() {
        return this.percent;
    }

    public int getStyle() {
        return this.style;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public boolean isTypeActivity() {
        return this.type == 1;
    }

    public boolean isTypeError() {
        return this.type == 5;
    }

    public boolean isTypeMessage() {
        return this.type == 4;
    }

    public boolean isTypeProgress() {
        return this.type == 0;
    }

    public boolean isTypeStatus() {
        return this.type == 3;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setPercent(int pPercent) {
        if (pPercent == 0) {
            this.index = 0;
        } else if (pPercent > this.percent) {
            ++this.index;
        } else if (pPercent < this.percent) {
            --this.index;
        }
        this.percent = pPercent;
    }
}

