/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.sax.ISAXElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXContextBasedHandler
extends DefaultHandler {
    private int nesting = 0;
    private Locator locator = null;
    private ISAXElementHandler documentElement = null;
    private ISAXElementHandler current = null;
    private ClassLoader classLoader;
    private Exception exception;
    private IStringEvaluator templateEvaluator;
    private ISAXElementHandler[] stack = new ISAXElementHandler[10];
    private int stackIndex = -1;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.current.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.isStarted()) {
            throw new SAXException("document not started");
        }
        if (!this.isDocumentElementLevel()) {
            throw new SAXException("document has open elements");
        }
        this.current.endDocumentElement();
        this.pop();
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        ISAXElementHandler element = this.current;
        this.markEndLocation(element);
        element.endElement(uri, local, name);
        this.pop();
        this.current.endChildElement(element);
        --this.nesting;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.setException(e);
        throw e;
    }

    public void fail() {
        this.reset();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.setException(e);
        throw e;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public ISAXElementHandler getCurrent() {
        return this.current;
    }

    public abstract ISAXElementHandler getDefaultDocumentElement();

    public ISAXElementHandler getDocumentElement() {
        if (this.documentElement == null) {
            this.documentElement = this.getDefaultDocumentElement();
        }
        return this.documentElement;
    }

    public String getErrorString(SAXParseException e) {
        String errorString = "";
        errorString = this.current != null ? "in <" + this.current.getLocalName() + "> at " : "at ";
        errorString = String.valueOf(errorString) + this.getLocationString(e) + " " + e.getMessage();
        return errorString;
    }

    public IStringEvaluator getTemplateEvaluator() {
        return this.templateEvaluator;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getLocationString(SAXParseException e) {
        StringBuilder str = new StringBuilder();
        String systemId = e.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
            str.append(':');
        }
        str.append("line ");
        str.append(e.getLineNumber());
        str.append(", column ");
        str.append(e.getColumnNumber());
        return str.toString();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public int getNesting() {
        return this.nesting;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.current.ignorableWhitespace(ch, start, length);
    }

    public boolean isDocumentElementLevel() {
        return this.current == this.getDocumentElement();
    }

    public boolean isEmpty() {
        return this.stackIndex < 0;
    }

    public boolean isError() {
        return this.getException() != null;
    }

    public boolean isStarted() {
        return this.stackIndex >= 0;
    }

    protected void markEndLocation(ISAXElementHandler element) {
        Locator tempLocator = this.getLocator();
        if (tempLocator != null) {
            element.markEndLocation(tempLocator.getLineNumber(), tempLocator.getColumnNumber());
        }
    }

    protected void markStartLocation(ISAXElementHandler newHandler) {
        Locator tempLocator = this.getLocator();
        if (tempLocator != null) {
            newHandler.markStartLocation(tempLocator.getLineNumber(), tempLocator.getColumnNumber());
        }
    }

    private void pop() {
        this.stack[this.stackIndex--] = null;
        this.current = this.stackIndex < 0 ? null : this.stack[this.stackIndex];
    }

    private void push(ISAXElementHandler newHandler) {
        newHandler.setContextHandler(this);
        newHandler.setParent(this.current);
        this.current = newHandler;
        if (++this.stackIndex == this.stack.length) {
            ISAXElementHandler[] newStack = new ISAXElementHandler[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.stackIndex] = newHandler;
    }

    public void reset() {
        this.current = null;
        this.documentElement = null;
        this.nesting = 0;
        this.locator = null;
        this.exception = null;
        this.stackIndex = -1;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setDocumentElement(ISAXElementHandler e) {
        this.documentElement = e;
    }

    @Override
    public void setDocumentLocator(Locator newlocator) {
        this.locator = newlocator;
    }

    public void setTemplateEvaluator(IStringEvaluator evaluator) {
        this.templateEvaluator = evaluator;
    }

    public void setException(Exception newException) {
        this.exception = newException;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isStarted()) {
            throw new SAXException("document already started");
        }
        this.nesting = 0;
        this.push(this.getDocumentElement());
        this.current.initializeDocumentElement();
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attrs) throws SAXException {
        ++this.nesting;
        ISAXElementHandler previous = this.current;
        Attributes newAttrs = this.substitute(attrs);
        ISAXElementHandler newHandler = previous.startElement(uri, local, name, newAttrs);
        this.push(newHandler);
        this.markStartLocation(newHandler);
        newHandler.initialize(uri, local, name, newAttrs);
        if (newAttrs != null) {
            newHandler.processAttributes(newAttrs);
        }
        newHandler.started();
        previous.startChildElement(newHandler);
    }

    public Attributes substitute(Attributes attributes) {
        if (this.getTemplateEvaluator() == null || attributes == null) {
            return attributes;
        }
        Attributes result = attributes;
        int length = result.getLength();
        int i = 0;
        while (i < length) {
            String value = result.getValue(i);
            if (value.indexOf(36) >= 0) {
                Object expanded;
                if (result == attributes) {
                    result = new AttributesImpl(attributes);
                }
                try {
                    expanded = this.getTemplateEvaluator().evaluate(value, Args.create());
                }
                catch (EvaluationException e) {
                    expanded = "<error expanding '" + value + "'";
                }
                ((AttributesImpl)result).setValue(i, String.valueOf(expanded));
            }
            ++i;
        }
        return result;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.setException(e);
        throw e;
    }
}

