/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.sax.DefaultWriterFactory;
import de.intarsys.tools.sax.IWriterFactory;
import de.intarsys.tools.sax.SAXContextBasedHandler;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.SAXException;

public abstract class SAXContextBasedWriter
extends SAXContextBasedHandler {
    private IWriterFactory writerFactory;
    private Writer output;

    public SAXContextBasedWriter(IWriterFactory wf) {
        this.setWriterFactory(wf);
    }

    public SAXContextBasedWriter(Writer w) {
        this.setOutput(w);
    }

    public void closeWriter() throws SAXException {
        try {
            if (this.getOutput() != null && this.getWriterFactory() != null) {
                this.getWriterFactory().closeWriter(this.getOutput());
                this.setOutput(null);
            }
        }
        catch (Exception e) {
            throw new SAXException("error closing writer (" + e.getMessage() + ")", e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.closeWriter();
    }

    public Writer getOutput() {
        return this.output;
    }

    public IWriterFactory getWriterFactory() {
        if (this.writerFactory == null) {
            this.writerFactory = new DefaultWriterFactory();
        }
        return this.writerFactory;
    }

    public void openWriter() throws SAXException {
        if (this.getOutput() != null) {
            return;
        }
        try {
            this.setOutput(this.getWriterFactory().createWriter());
        }
        catch (Exception e) {
            throw new SAXException("error opening writer (" + e.getMessage() + ")", e);
        }
    }

    protected void setOutput(Writer newOutput) {
        this.output = newOutput;
    }

    protected void setWriterFactory(IWriterFactory newWriterFactory) {
        this.writerFactory = newWriterFactory;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.openWriter();
    }

    protected void write(char c) throws SAXException {
        try {
            this.getOutput().write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void write(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.write(ch[i]);
            ++i;
        }
    }

    protected void write(String s) throws SAXException {
        try {
            this.getOutput().write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void writeln() throws SAXException {
        try {
            this.getOutput().write(StringTools.LS);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

