/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.encoding.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.parsers.SAXParserFactory;

public class SAXTools {
    private static SAXParserFactory parserFactory;

    public static SAXParserFactory createParserFactory() {
        String parserFactoryName = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (parserFactoryName == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory result = SAXParserFactory.newInstance();
        return result;
    }

    public static Object deserialize(char[] ch) {
        return SAXTools.deserialize(ch, 0, ch.length);
    }

    public static Object deserialize(char[] ch, int start, int length) {
        return SAXTools.deserialize(new String(ch, start, length));
    }

    public static Object deserialize(String value) {
        Object object;
        try {
            byte[] decodedValue = Base64.decode(value.getBytes());
            ByteArrayInputStream byteArrayStream = new ByteArrayInputStream(decodedValue);
            ObjectInputStream objectStream = new ObjectInputStream(byteArrayStream);
            object = objectStream.readObject();
            objectStream.close();
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
        catch (IOException ignore) {
            return null;
        }
        return object;
    }

    public static SAXParserFactory getParserFactory() {
        if (parserFactory == null) {
            parserFactory = SAXTools.createParserFactory();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
        }
        return parserFactory;
    }

    public static char[] serializeToCharArray(Object object) {
        return SAXTools.serializeToString(object).toCharArray();
    }

    public static String serializeToString(Object object) {
        ByteArrayOutputStream byteArrayStream;
        try {
            byteArrayStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteArrayStream);
            objectStream.writeObject(object);
            objectStream.close();
        }
        catch (IOException ignore) {
            return null;
        }
        byte[] byteValue = byteArrayStream.toByteArray();
        return new String(Base64.encode(byteValue));
    }
}

