/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.SAXAbstractElementWriter;
import de.intarsys.tools.sax.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLElementWriter
extends SAXAbstractElementWriter {
    protected String acceptTag(String name) throws SAXException {
        StringBuilder buf = new StringBuilder();
        if (name != null && name.length() > 0 && !this.mayBeFirstChar(name.charAt(0))) {
            if (this.isFixTag()) {
                buf.append('_');
            } else {
                throw new SAXException("first character in tag <" + name + "> must be a letter, '_' or ':'");
            }
        }
        buf.append(name);
        int i = 0;
        while (i < buf.length()) {
            if (!this.isNameChar(buf.charAt(i))) {
                if (this.isFixTag()) {
                    buf.setCharAt(i, '_');
                } else {
                    throw new SAXException("illegal characters in tag <" + name + ">: " + buf.charAt(i));
                }
            }
            ++i;
        }
        return new String(buf);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.writeEsc(ch, start, len, false);
        super.characters(ch, start, len);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.isLeaf() && this.isPrettyPrint()) {
            this.writeln();
            this.writeIndent();
        }
        this.write("</");
        this.writeName(uri, localName, qName, true);
        this.write('>');
        if (this.getNesting() == 1) {
            this.writeln();
        }
        super.endElement(uri, localName, qName);
    }

    public int getIndent() {
        return ((XMLWriter)this.getContextHandler()).getIndent();
    }

    public boolean isFixTag() {
        return ((XMLWriter)this.getContextHandler()).isFixTag();
    }

    protected boolean isNameChar(char c) {
        return this.mayBeFirstChar(c) || c >= '0' && c <= '9' || c == '.' || c == '-';
    }

    public boolean isPrettyPrint() {
        return ((XMLWriter)this.getContextHandler()).isPrettyPrint();
    }

    public boolean isWriteAttributes() {
        return ((XMLWriter)this.getContextHandler()).isWriteAttributes();
    }

    protected boolean mayBeFirstChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == ':';
    }

    @Override
    public ISAXElementHandler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isPrettyPrint()) {
            this.writeln();
            this.writeIndent();
        }
        this.write('<');
        this.writeName(uri, localName, qName, true);
        if (this.isWriteAttributes()) {
            this.writeAttributes(atts);
        }
        this.write('>');
        return new XMLElementWriter();
    }

    protected void writeAttributes(Attributes atts) throws SAXException {
        if (atts == null) {
            return;
        }
        int len = atts.getLength();
        int i = 0;
        while (i < len) {
            char[] ch = atts.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
            this.write("=\"");
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
            ++i;
        }
    }

    protected void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        int i = start;
        while (i < start + length) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        break;
                    }
                    this.write('\"');
                    break;
                }
                default: {
                    if (ch[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(ch[i]));
                        this.write(';');
                        break;
                    }
                    this.write(ch[i]);
                }
            }
            ++i;
        }
    }

    protected void writeIndent() throws SAXException {
        if (this.getIndent() > 0 && this.getNesting() > 1) {
            int n = this.getIndent() * (this.getNesting() - 1);
            char[] ch = new char[n];
            int i = 0;
            while (i < n) {
                ch[i] = 32;
                ++i;
            }
            this.write(ch, 0, n);
        }
    }

    protected void writeName(String uri, String localName, String qName, boolean isElement) throws SAXException {
        String name = this.acceptTag(localName);
        this.write(name);
    }
}

