/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class BONSerializer
implements ISerializer {
    private final OutputStream os;
    private String charset = "UTF-8";
    private boolean first = true;

    public BONSerializer(OutputStream os) {
        this.os = os;
    }

    public BONSerializer(OutputStream os, String charset) {
        this.os = os;
        this.charset = charset;
    }

    protected void basicSerialize(Object object) throws IOException {
        if (object == null) {
            this.os.write(StringTools.toByteArray("null"));
        } else if (object instanceof Number) {
            this.os.write(StringTools.toByteArray(String.valueOf(object)));
        } else if (object instanceof Boolean) {
            this.os.write(StringTools.toByteArray(String.valueOf(object)));
        } else if (object instanceof String) {
            this.serializeString((String)object);
        } else if (object instanceof byte[]) {
            this.serializeBase64((byte[])object);
        } else if (object instanceof List) {
            this.serializeList((List)object);
        } else if (object instanceof Map) {
            this.serializeMap((Map)object);
        } else {
            throw new IOException("unknown object type " + object.getClass());
        }
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void serialize(Object object) throws IOException {
        if (!this.first) {
            this.os.write(32);
        }
        this.first = false;
        this.basicSerialize(object);
    }

    protected void serializeBase64(byte[] object) throws IOException {
        this.os.write(64);
        this.os.write(Base64.encode(object));
        this.os.write(64);
    }

    protected void serializeList(List object) throws IOException {
        boolean addSeparator = false;
        this.os.write(91);
        for (Object element : object) {
            if (addSeparator) {
                this.os.write(44);
            }
            addSeparator = true;
            this.basicSerialize(element);
        }
        this.os.write(93);
    }

    protected void serializeMap(Map<Object, Object> object) throws IOException {
        boolean addSeparator = false;
        this.os.write(123);
        for (Map.Entry<Object, Object> entry : object.entrySet()) {
            if (addSeparator) {
                this.os.write(44);
            }
            addSeparator = true;
            this.basicSerialize(entry.getKey());
            this.os.write(58);
            this.basicSerialize(entry.getValue());
        }
        this.os.write(125);
    }

    protected void serializeString(String object) throws IOException {
        this.os.write(34);
        byte[] bytes = object.getBytes(this.getCharset());
        int i = 0;
        while (i < bytes.length) {
            byte c = bytes[i];
            if (c == 92) {
                this.os.write(92);
            } else if (c == 34) {
                this.os.write(92);
            }
            this.os.write(c);
            ++i;
        }
        this.os.write(34);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

