/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.mime.IMimeTypeSupport;
import de.intarsys.tools.serialize.IDeserializer;
import de.intarsys.tools.serialize.ISerializationFactory;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.StreamSerializationContext;
import de.intarsys.tools.serialize.StringDeserializer;
import de.intarsys.tools.serialize.StringSerializer;

public class StringSerializationFactory
implements ISerializationFactory,
IMimeTypeSupport {
    public static final String MIMETYPE = "text/plain";
    private String charset = "UTF-8";

    public StringSerializationFactory() {
    }

    public StringSerializationFactory(String charset) {
        this.charset = charset;
    }

    @Override
    public IDeserializer createDeserializer(SerializationContext context) {
        return new StringDeserializer(((StreamSerializationContext)context).getInputStream(), this.getCharset());
    }

    @Override
    public ISerializer createSerializer(SerializationContext context) {
        return new StringSerializer(((StreamSerializationContext)context).getOutputStream(), this.getCharset());
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return MIMETYPE;
    }

    @Override
    public Class getSerializationType() {
        return Object.class;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

