/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize.xml;

import de.intarsys.tools.serialize.CommonSerializer;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializationContext;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XMLSerializer
extends CommonSerializer {
    protected static String DEFAULT_ENCODING = "iso-8859-1";
    protected static AttributesImpl ATTRS_EMPTY = new AttributesImpl();
    private boolean createDocument = false;

    protected static void addAttribute(AttributesImpl attrs, String name, String value) {
        if (value == null) {
            return;
        }
        attrs.addAttribute("", name, name, null, value);
    }

    protected static String normalizeAttributeValue(String value) {
        return value;
    }

    public XMLSerializer(SerializationContext context) {
        super(context);
    }

    public XMLSerializer(SerializationContext context, boolean createDocument) {
        super(context);
        this.createDocument = createDocument;
    }

    protected void doCharacters(ContentHandler handler, char[] chars) throws SAXException {
        if (chars == null) {
            return;
        }
        handler.characters(chars, 0, chars.length);
    }

    protected void doCharacters(ContentHandler handler, String string) throws SAXException {
        if (string == null) {
            return;
        }
        char[] chars = string.toCharArray();
        handler.characters(chars, 0, chars.length);
    }

    protected void doElement(ContentHandler handler, String name, AttributesImpl attrs, String value) throws SAXException, IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        handler.startElement("", name, name, attrs);
        char[] chars = value.toCharArray();
        handler.characters(chars, 0, chars.length);
        handler.endElement("", name, name);
    }

    protected void doElement(ContentHandler handler, String name, String value) throws SAXException, IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        handler.startElement("", name, name, ATTRS_EMPTY);
        char[] chars = value.toCharArray();
        handler.characters(chars, 0, chars.length);
        handler.endElement("", name, name);
    }

    protected void doEndElement(ContentHandler handler, String name) throws SAXException {
        handler.endElement("", name, name);
    }

    protected void doStartElement(ContentHandler handler, String name, AttributesImpl attrs) throws SAXException {
        handler.startElement("", name, name, attrs);
    }

    public boolean isCreateDocument() {
        return this.createDocument;
    }

    @Override
    public final void serialize(Object object) throws IOException {
        XMLSerializationContext xmlContext = (XMLSerializationContext)this.getContext();
        try {
            this.createContentHandler(xmlContext).startDocument();
            this.serialize(object, this.createContentHandler(xmlContext));
            this.createContentHandler(xmlContext).endDocument();
        }
        catch (SAXException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected ContentHandler createContentHandler(XMLSerializationContext xmlContext) {
        return xmlContext.getContentHandler();
    }

    protected abstract void serialize(Object var1, ContentHandler var2) throws SAXException, IOException;

    protected void serialize(Object object, OutputStream os, boolean createDocument) throws IOException {
        ContentHandler handler = XMLSerializationContext.createContentHandler(os, createDocument);
        try {
            handler.startDocument();
            this.serialize(object, handler);
            handler.endDocument();
        }
        catch (SAXException e) {
            IOException ioe = new IOException("sax exception (" + e.getMessage() + ")");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void setCreateDocument(boolean createDocument) {
        this.createDocument = createDocument;
    }
}

