/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.string.StringTools;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpStream
extends FilterOutputStream {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int BYTES_PER_LINE = 16;
    private int tbc = 0;
    private int lbc = 0;
    private final char[] line = new char[BYTES_PER_LINE];

    public HexDumpStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        String tbcString = Long.toHexString(this.tbc);
        int i = tbcString.length();
        while (i < 8) {
            this.out.write(48);
            ++i;
        }
        this.out.write(tbcString.getBytes());
        this.out.write(32);
        i = 0;
        while (i < this.lbc) {
            this.out.write(hex[this.line[i] >> 4 & 0xF]);
            this.out.write(hex[this.line[i] >> 0 & 0xF]);
            this.out.write(32);
            ++i;
        }
        while (i < BYTES_PER_LINE) {
            this.out.write(32);
            this.out.write(32);
            this.out.write(32);
            ++i;
        }
        this.out.write(32);
        i = 0;
        while (i < this.lbc) {
            if (Character.isISOControl(this.line[i])) {
                this.out.write(46);
            } else {
                this.out.write(this.line[i]);
            }
            ++i;
        }
        this.out.write(StringTools.LS.getBytes());
        this.tbc += this.lbc;
        this.lbc = 0;
        super.flush();
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.line[this.lbc++] = (char)b;
        if (this.lbc >= BYTES_PER_LINE) {
            this.flush();
        }
    }
}

