/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Converter {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static boolean asBoolean(String booleanString) throws ConverterException {
        if ((booleanString = booleanString.toLowerCase().trim()).equals("false") || booleanString.equals("f") || booleanString.equals("no") || booleanString.equals("n") || booleanString.equals("0") || booleanString.equals("falsch") || booleanString.equals("nein")) {
            return false;
        }
        if (booleanString.equals("true") || booleanString.equals("t") || booleanString.equals("yes") || booleanString.equals("y") || booleanString.equals("1") || booleanString.equals("wahr") || booleanString.equals("w") || booleanString.equals("ja") || booleanString.equals("j")) {
            return true;
        }
        throw new ConverterException("Can't parse boolean string: " + booleanString + " to a legal value");
    }

    public static boolean asBoolean(String booleanString, boolean defaultValue) {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        try {
            return Converter.asBoolean(booleanString);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static boolean asBooleanChecked(String booleanString, boolean defaultValue) throws ConverterException {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        return Converter.asBoolean(booleanString);
    }

    public static byte[] asBytes(String str) throws ConverterException {
        if (str.startsWith("[a]")) {
            try {
                return str.substring(3).getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new ConverterException(e);
            }
        }
        if (str.startsWith("[x]")) {
            return HexTools.hexStringToBytes(str.substring(3));
        }
        if (str.startsWith("[@]")) {
            return Base64.decode(str.substring(3));
        }
        return Base64.decode(str.substring(3));
    }

    public static double asDouble(String str) throws ConverterException {
        try {
            str = str.trim();
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse number string: " + str + " to a legal value");
        }
    }

    public static double asDouble(String str, double defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asDouble(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static double asDoubleChecked(String str, double defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asDouble(str);
    }

    public static File asFile(String pValue) throws ConverterException {
        String str = pValue.trim();
        if ((str = FileTools.trimPath(str)).equals("")) {
            throw new ConverterException("Parameter " + pValue + " is not a valid Filename");
        }
        try {
            return new File(str);
        }
        catch (NullPointerException e) {
            throw new ConverterException("Can't parse file string: " + str + " to a file");
        }
    }

    public static float asFloat(String str) throws ConverterException {
        try {
            str = str.trim();
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse number string: " + str + " to a legal value");
        }
    }

    public static float asFloat(String str, float defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asFloat(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static float[] asFloatArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        float[] result = new float[tk.countTokens()];
        int i = 0;
        try {
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                result[i] = Float.parseFloat(token.trim());
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    public static float asFloatChecked(String str, float defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asFloat(str);
    }

    public static int[] asIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        int[] result = new int[tk.countTokens()];
        int i = 0;
        try {
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                result[i] = Integer.parseInt(token.trim());
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    public static int asInteger(String str) throws ConverterException {
        try {
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse integer string: " + str + " to a legal value");
        }
    }

    public static int asInteger(String str, int defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asInteger(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static int asIntegerChecked(String str, int defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asInteger(str);
    }

    public static List<String> asList(String string) {
        ArrayList<String> result = new ArrayList<String>();
        StringReader r = new StringReader(string);
        try {
            String value;
            while ((value = ReaderTools.readToken(r, ';')) != null) {
                result.add(value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static long asLong(String str) throws ConverterException {
        try {
            str = str.trim();
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Can't parse integer string: " + str + " to a legal value");
        }
    }

    public static long asLong(String str, long defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Converter.asLong(str);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    public static long asLongChecked(String str, long defaultValue) throws ConverterException {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return Converter.asLong(str);
    }

    public static Map<String, String> asMap(String string) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (StringTools.isEmpty(string)) {
            return map;
        }
        StringReader r = new StringReader(string);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, Boolean> asMapBoolean(String string) {
        Map<String, String> stringMap = Converter.asMap(string);
        HashMap<String, Boolean> boolMap = new HashMap<String, Boolean>(stringMap.size() * 2);
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            Boolean value = Boolean.valueOf(entry.getValue());
            boolMap.put(entry.getKey(), value);
        }
        return boolMap;
    }

    public static String asString(String str, String defaultValue) {
        if (StringTools.isEmpty(str)) {
            return defaultValue;
        }
        return str.trim();
    }

    public static String[] asStringArray(String value) {
        if (value == null) {
            return null;
        }
        return value.split(ELEMENT_SEPARATOR);
    }

    public static Boolean asThreeState(String booleanString) throws ConverterException {
        if ((booleanString = booleanString.toLowerCase().trim()).equals("false") || booleanString.equals("f") || booleanString.equals("no") || booleanString.equals("n") || booleanString.equals("0") || booleanString.equals("falsch") || booleanString.equals("nein")) {
            return Boolean.FALSE;
        }
        if (booleanString.equals("true") || booleanString.equals("t") || booleanString.equals("yes") || booleanString.equals("y") || booleanString.equals("1") || booleanString.equals("wahr") || booleanString.equals("w") || booleanString.equals("ja") || booleanString.equals("j")) {
            return Boolean.TRUE;
        }
        if (booleanString.equals("undeterminate") || booleanString.equals("undefined") || booleanString.equals("?") || booleanString.equals("u")) {
            return null;
        }
        throw new ConverterException("Can't parse boolean string: " + booleanString + " to a legal value");
    }

    public static Boolean asThreeState(String booleanString, Boolean defaultValue) {
        if (StringTools.isEmpty(booleanString)) {
            return defaultValue;
        }
        try {
            return Converter.asBoolean(booleanString);
        }
        catch (ConverterException e) {
            return defaultValue;
        }
    }

    private Converter() {
    }
}

