/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tag;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.ITagSupport;
import de.intarsys.tools.tag.Tag;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class TagTools {
    private static final Attribute ATTR_TAGS = new Attribute("tags");
    private static final Tag[] EMPTY = new Tag[0];
    private static final Map<Object, List<Tag>> tagsMap = new WeakHashMap<Object, List<Tag>>();

    public static void addTag(Object object, String key, String value) {
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(new Tag(key, value));
    }

    public static void addTag(Object object, Tag tag) {
        if (tag == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(tag);
    }

    public static void addTags(Object object, List<Tag> pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.addAll(pTags);
    }

    public static void addTags(Object object, Map<String, String> pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        for (Map.Entry<String, String> entry : pTags.entrySet()) {
            tags.add(new Tag(entry.getKey(), entry.getValue()));
        }
    }

    public static void addTags(Object object, String tagString) {
        if (StringTools.isEmpty(tagString)) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        StringReader r = new StringReader(tagString);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                tags.add(new Tag(entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addTags(Object object, Tag[] pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.addAll(Arrays.asList(pTags));
    }

    protected static List<Tag> basicGetTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            ArrayList tags = (ArrayList)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            if (tags == null) {
                tags = new ArrayList();
                ((IAttributeSupport)object).setAttribute(ATTR_TAGS, tags);
            }
            return tags;
        }
        List<Tag> tags = tagsMap.get(object);
        if (tags == null) {
            tags = new ArrayList<Tag>();
            tagsMap.put(object, tags);
        }
        return tags;
    }

    protected static List<Tag> basicLookupTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            List tags = (List)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            return tags;
        }
        List<Tag> tags = tagsMap.get(object);
        return tags;
    }

    public static void configureTags(Object target, IElement pElement) {
        IElement elTags = pElement.element("tags");
        if (elTags != null) {
            Iterator<IElement> itTags = elTags.elementIterator("tag");
            while (itTags.hasNext()) {
                IElement elTag = itTags.next();
                String key = elTag.attributeValue("key", "");
                String value = elTag.attributeValue("value", "true");
                TagTools.addTag(target, key, value);
            }
        }
    }

    public static Tag getTag(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return null;
        }
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            return tag;
        }
        return null;
    }

    public static Tag[] getTags(Object object) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return EMPTY;
        }
        return tags.toArray(new Tag[tags.size()]);
    }

    public static Tag[] getTags(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return EMPTY;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            result.add(tag);
        }
        return result.toArray(new Tag[result.size()]);
    }

    public static String getTagValue(Object object, String key, String defaultValue) {
        Tag tag = TagTools.getTag(object, key);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public static String[] getTagValues(Object object) {
        Tag[] tags = TagTools.getTags(object);
        String[] values = new String[tags.length];
        int i = 0;
        while (i < values.length) {
            values[i] = tags[i].getValue();
            ++i;
        }
        return values;
    }

    public static String[] getTagValues(Object object, String key) {
        Tag[] tags = TagTools.getTags(object, key);
        String[] values = new String[tags.length];
        int i = 0;
        while (i < values.length) {
            values[i] = tags[i].getValue();
            ++i;
        }
        return values;
    }

    public static boolean hasTag(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return false;
        }
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTags(Object object) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return false;
        }
        return !tags.isEmpty();
    }

    public static Tag parseTag(String definition) {
        Map.Entry<String, String> entry;
        String value;
        String key;
        block6: {
            block5: {
                key = "";
                value = "";
                StringReader r = new StringReader(definition);
                entry = ReaderTools.readEntry(r, ';');
                if (entry != null) break block5;
                return null;
            }
            if (entry.getKey() != null) break block6;
            return null;
        }
        try {
            key = entry.getKey();
            if (entry.getValue() != null) {
                value = entry.getValue();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Tag(key, value);
    }

    public static List<Tag> parseTags(String definition) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        StringReader r = new StringReader(definition);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                result.add(new Tag(entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void removeTags(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return;
        }
        Iterator<Tag> it = tags.iterator();
        while (it.hasNext()) {
            Tag tag = it.next();
            if (!key.equals(tag.getKey())) continue;
            it.remove();
        }
    }

    public static void setTag(Object object, String key, String value) {
        TagTools.removeTags(object, key);
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(new Tag(key, value));
    }
}

