/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.tlv.common.SimpleInputStream;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SimpleElement
extends TlvElement {
    public static SimpleElement parseElement(byte[] encoded, int offset, int length) throws IOException {
        SimpleInputStream is = new SimpleInputStream(encoded, offset, length);
        return (SimpleElement)is.readElement();
    }

    public static TlvTemplate parseTemplate(byte[] encoded, int offset, int length) throws IOException {
        SimpleInputStream is = new SimpleInputStream(encoded, offset, length);
        return new TlvTemplate(is);
    }

    public SimpleElement(int identifier, byte[] buffer) {
        super(identifier, buffer);
        if (identifier <= 0 || identifier >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public SimpleElement(int identifier, byte[] buffer, int offset, int length) {
        super(identifier, buffer, offset, length);
        if (identifier <= 0 || identifier >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    @Override
    public TlvInputStream createTlvInputStream(byte[] pBytes, int pOffset, int pLength) throws TlvFormatException {
        return new SimpleInputStream(pBytes, pOffset, pLength);
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.getIdentifier());
        if (this.getLength() < 255) {
            out.write(this.getLength());
        } else if (this.getLength() <= 65535) {
            out.write(255);
            out.write(this.getLength() >> 8 & 0xFF);
            out.write(this.getLength() & 0xFF);
        } else {
            throw new IllegalArgumentException("size > 0xFFFF not supported");
        }
        out.write(this.buffer, this.offset, this.length);
        return out.toByteArray();
    }

    @Override
    public boolean isComposite() {
        return false;
    }
}

