/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TlvTemplate
implements Iterable<TlvElement> {
    private final List<TlvElement> elements = new ArrayList<TlvElement>();

    public TlvTemplate() {
    }

    public TlvTemplate(TlvInputStream is) throws TlvFormatException {
        try {
            TlvElement element = is.readElement();
            while (element != null) {
                this.elements.add(element);
                element = is.readElement();
            }
        }
        catch (IOException e) {
            throw new TlvFormatException(e.getMessage(), e);
        }
    }

    public void addElement(TlvElement element) {
        this.elements.add(element);
    }

    public TlvElement getElementAt(int index) {
        if (index < 0 || index >= this.elements.size()) {
            return null;
        }
        return this.elements.get(index);
    }

    public TlvElement getElementTagged(int identifier) {
        for (TlvElement element : this.elements) {
            if (element.getIdentifier() != identifier) continue;
            return element;
        }
        return null;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (TlvElement element : this.elements) {
            try {
                os.write(element.getEncoded());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return os.toByteArray();
    }

    @Override
    public Iterator<TlvElement> iterator() {
        return this.elements.iterator();
    }

    public Iterator<TlvElement> iteratorTagged(final int identifier) {
        return new FilterIterator<TlvElement>(this.iterator()){

            @Override
            protected boolean accept(TlvElement object) {
                return object.getIdentifier() == identifier;
            }
        };
    }
}

