/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.ITransaction;
import de.intarsys.tools.transaction.ITransactionManager;
import de.intarsys.tools.transaction.NoTransactionException;
import de.intarsys.tools.transaction.RootTransaction;
import de.intarsys.tools.transaction.Transaction;
import de.intarsys.tools.transaction.TransactionException;

public abstract class CommonTransactionManager
implements ITransactionManager {
    @Override
    public void begin() {
        Transaction tx = this.lookupTransaction();
        Transaction newTransaction = null;
        newTransaction = tx == null ? this.createTransaction() : tx.createTransaction();
        newTransaction.start();
        this.registerTransaction(newTransaction);
    }

    @Override
    public void commit() throws TransactionException {
        Transaction tx = this.lookupTransaction();
        if (tx == null) {
            throw new NoTransactionException("no transaction active when commiting");
        }
        Transaction parent = (Transaction)tx.getParent();
        tx.commit();
        this.registerTransaction(parent);
    }

    @Override
    public void commitResume() throws TransactionException {
        Transaction tx = this.lookupTransaction();
        if (tx == null) {
            throw new NoTransactionException("no transaction active when commiting");
        }
        tx.commitResume();
    }

    protected Transaction createTransaction() {
        return new RootTransaction();
    }

    @Override
    public ITransaction getTransaction() {
        return this.lookupTransaction();
    }

    protected abstract Transaction lookupTransaction();

    protected abstract void registerTransaction(Transaction var1);

    @Override
    public void resume(ITransaction transaction) {
        Transaction tx = this.lookupTransaction();
        if (tx == transaction) {
            return;
        }
        if (tx != null) {
            tx.suspend();
        }
        ((Transaction)transaction).resume();
        this.registerTransaction((Transaction)transaction);
    }

    @Override
    public void rollback() throws TransactionException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            Transaction parent = (Transaction)tx.getParent();
            tx.rollback();
            this.registerTransaction(parent);
        }
    }

    @Override
    public void rollbackResume() throws TransactionException {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            tx.rollbackResume();
        }
    }

    @Override
    public ITransaction suspend() {
        Transaction tx = this.lookupTransaction();
        if (tx != null) {
            tx.suspend();
            this.registerTransaction(null);
        }
        return tx;
    }
}

