/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.IResource;
import de.intarsys.tools.transaction.IResourceType;
import de.intarsys.tools.transaction.ITransaction;
import de.intarsys.tools.transaction.PACKAGE;
import de.intarsys.tools.transaction.ResourceException;
import de.intarsys.tools.transaction.SubTransaction;
import de.intarsys.tools.transaction.TransactionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Transaction
implements ITransaction,
Serializable {
    private static int ID_COUNTER = 0;
    private static Logger Log = PACKAGE.Log;
    private final List children = new ArrayList();
    private final String id = String.valueOf(ID_COUNTER++);
    private final List<IResource> resources = new ArrayList<IResource>();

    protected Transaction() {
    }

    protected void addTransaction(Transaction tx) {
        this.children.add(tx);
    }

    @Override
    public void commit() throws TransactionException {
        ArrayList lcChildren = new ArrayList(this.children);
        for (Transaction child : lcChildren) {
            child.commit();
        }
        this.commitResources();
        this.stop();
    }

    protected void commitResources() throws TransactionException {
        for (IResource resource : this.resources) {
            try {
                resource.commit();
            }
            catch (ResourceException e) {
                throw new TransactionException(e);
            }
        }
    }

    @Override
    public void commitResume() throws TransactionException {
        ArrayList lcChildren = new ArrayList(this.children);
        for (Transaction child : lcChildren) {
            child.commitResume();
        }
        this.commitResources();
    }

    protected Transaction createTransaction() {
        return new SubTransaction(this);
    }

    public void delist(IResource resource) throws TransactionException {
        if (!this.resources.remove(resource)) {
            throw new TransactionException("resource not listed");
        }
        try {
            resource.rollback();
        }
        catch (ResourceException e) {
            throw new TransactionException(e);
        }
    }

    public void enlist(IResource resource) throws TransactionException {
        try {
            resource.begin();
        }
        catch (ResourceException e) {
            throw new TransactionException(e);
        }
        this.resources.add(resource);
    }

    public String getId() {
        return this.id;
    }

    protected <T extends IResource> T getResource(IResourceType<T> resourceType) {
        for (IResource resource : this.resources) {
            if (resource.getType() != resourceType) continue;
            return (T)resource;
        }
        return null;
    }

    protected void removeTransaction(Transaction tx) {
        this.children.remove(tx);
    }

    protected void resume() {
        if (this.getParent() != null) {
            ((Transaction)this.getParent()).resume();
        }
        for (IResource resource : this.resources) {
            resource.resume();
        }
        Log.log(Level.FINE, "transaction[" + this.getId() + "] resumed");
    }

    @Override
    public void rollback() throws TransactionException {
        ArrayList lcChildren = new ArrayList(this.children);
        for (Transaction child : lcChildren) {
            child.rollback();
        }
        this.rollbackResources();
        this.stop();
    }

    protected void rollbackResources() throws TransactionException {
        for (IResource resource : this.resources) {
            try {
                resource.rollback();
            }
            catch (ResourceException e) {
                throw new TransactionException(e);
            }
        }
    }

    @Override
    public void rollbackResume() throws TransactionException {
        ArrayList lcChildren = new ArrayList(this.children);
        for (Transaction child : lcChildren) {
            child.rollbackResume();
        }
        this.rollbackResources();
    }

    protected void start() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] started");
    }

    protected void stop() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] stopped");
    }

    protected void suspend() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] suspended");
        ArrayList lcChildren = new ArrayList(this.children);
        for (Transaction child : lcChildren) {
            child.suspend();
        }
        for (IResource resource : this.resources) {
            resource.suspend();
        }
    }
}

