/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.IResource;
import de.intarsys.tools.transaction.IResourceType;
import de.intarsys.tools.transaction.NoTransactionException;
import de.intarsys.tools.transaction.Transaction;
import de.intarsys.tools.transaction.TransactionException;
import de.intarsys.tools.transaction.TransactionManager;

public class TransactionTools {
    public static void delist(IResource resource) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        transaction.delist(resource);
    }

    public static void enlist(IResource resource) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        transaction.enlist(resource);
    }

    public static <T extends IResource> T getResource(IResourceType<T> type, boolean create) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        return TransactionTools.getResource(type, transaction, create);
    }

    protected static <T extends IResource> T getResource(IResourceType<T> type, Transaction transaction, boolean create) throws TransactionException {
        T tempResource = transaction.getResource(type);
        if (tempResource == null) {
            if (create) {
                Object parentResource = null;
                Transaction parentTransaction = (Transaction)transaction.getParent();
                if (parentTransaction != null) {
                    parentResource = TransactionTools.getResource(type, parentTransaction, create);
                }
                tempResource = type.createResource(parentResource);
                transaction.enlist((IResource)tempResource);
            } else {
                throw new TransactionException("no resource found");
            }
        }
        return tempResource;
    }
}

