/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.transaction.CommonResource;
import de.intarsys.tools.transaction.ResourceException;
import de.intarsys.tools.transaction.file.FileSystemResourceType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileSystemResource
extends CommonResource {
    private List<IFunctor> rollbackActions = new ArrayList<IFunctor>();
    private List<IFunctor> commitActions = new ArrayList<IFunctor>();

    protected FileSystemResource(FileSystemResourceType type, FileSystemResource parent) {
        super(type, parent);
    }

    @Override
    public void commit() throws ResourceException {
        ArrayList<IFunctor> tempUndos = new ArrayList<IFunctor>(this.commitActions);
        for (IFunctor action : tempUndos) {
            FunctorCall call = new FunctorCall(this, Args.create());
            try {
                action.perform(call);
            }
            catch (FunctorInvocationException e) {
                throw new ResourceException(e);
            }
        }
        this.commitActions.clear();
        this.rollbackActions.clear();
    }

    public void onCommit(IFunctor action) {
        if (!this.isActive()) {
            return;
        }
        this.commitActions.add(action);
    }

    public void onRollback(IFunctor action) {
        if (!this.isActive()) {
            return;
        }
        this.rollbackActions.add(action);
    }

    public void onRollbackDelete(final File file) {
        if (file == null || !this.isActive()) {
            return;
        }
        this.onRollback(new IFunctor(){

            public Object perform(IFunctorCall call) throws FunctorInvocationException {
                file.delete();
                return null;
            }
        });
    }

    public void onRollbackMove(final File source, final File destination) {
        if (source == null || destination == null || source.equals(destination) || !this.isActive()) {
            return;
        }
        this.onRollback(new IFunctor(){

            public Object perform(IFunctorCall call) throws FunctorInvocationException {
                try {
                    FileTools.copyFile(source, destination);
                }
                catch (IOException e) {
                    throw new FunctorInvocationException(e);
                }
                source.delete();
                return null;
            }
        });
    }

    public void recordChange(final File file) throws IOException {
        if (file == null || !this.isActive()) {
            return;
        }
        final File tempFile = FileTools.createTempFile(file);
        FileTools.copyBinaryFile(file, tempFile);
        this.onRollback(new IFunctor(){

            public Object perform(IFunctorCall call) throws FunctorInvocationException {
                try {
                    FileTools.copyBinaryFile(tempFile, file);
                    tempFile.delete();
                }
                catch (IOException e) {
                    throw new FunctorInvocationException(e);
                }
                return null;
            }
        });
        this.onCommit(new IFunctor(){

            public Object perform(IFunctorCall call) throws FunctorInvocationException {
                tempFile.delete();
                return null;
            }
        });
    }

    @Override
    public void rollback() throws ResourceException {
        ArrayList<IFunctor> tempUndos = new ArrayList<IFunctor>(this.rollbackActions);
        Collections.reverse(tempUndos);
        for (IFunctor action : tempUndos) {
            FunctorCall call = new FunctorCall(this, Args.create());
            try {
                action.perform(call);
            }
            catch (FunctorInvocationException e) {
                throw new ResourceException(e);
            }
        }
        this.rollbackActions.clear();
        this.commitActions.clear();
    }
}

