/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tree;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.tree.CommonNodeFactory;
import de.intarsys.tools.tree.INodeHandler;

public abstract class CommonNode<T>
implements IPresentationSupport,
INotificationSupport,
IAttributeSupport {
    private static final CommonNode<?>[] NODES_EMPTY = new CommonNode[0];
    private AttributeMap attributes;
    private CommonNode<?>[] cachedChildren;
    private final EventDispatcher eventDispatcher;
    private final INotificationListener listenObjectChange = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            CommonNode.this.onEvent(event);
        }
    };
    private final INotificationListener listenObjectDestroy = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            CommonNode.this.onDestroy(event);
        }
    };
    private final T object;
    private final CommonNode<?> parent;
    private INodeHandler nodeHandler;

    public static synchronized CommonNode<?> getNode(CommonNode<?> parent, CommonNodeFactory<?> role, Object object) {
        CommonNode<Object> result = role.lookupNode(parent, object);
        if (result == null) {
            CommonNodeFactory<?> factory = role.lookupFactory(object);
            result = factory.createNode(parent, object);
            role.registerNode(parent, result);
        }
        return result;
    }

    protected CommonNode(CommonNode<?> parent, T object) {
        this.parent = parent;
        if (parent != null) {
            this.nodeHandler = parent.nodeHandler;
        }
        this.object = object;
        this.eventDispatcher = new EventDispatcher(this);
        this.arm();
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    protected void arm() {
        if (this.object instanceof INotificationSupport) {
            ((INotificationSupport)this.object).addNotificationListener(AttributeChangedEvent.ID, this.listenObjectChange);
            ((INotificationSupport)this.object).addNotificationListener(DestroyedEvent.ID, this.listenObjectDestroy);
        }
    }

    protected CommonNode<?>[] basicCreateChildren() {
        return NODES_EMPTY;
    }

    protected String basicGetDescription() {
        return this.getTip();
    }

    protected String basicGetIconName() {
        return null;
    }

    protected String basicGetLabel() {
        return this.object.toString();
    }

    protected String basicGetObjectDescription() {
        if (this.getObject() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getObject()).getDescription();
        }
        return this.basicGetDescription();
    }

    protected String basicGetObjectIconName() {
        if (this.getObject() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getObject()).getIconName();
        }
        return this.basicGetIconName();
    }

    protected String basicGetObjectLabel() {
        if (this.getObject() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getObject()).getLabel();
        }
        return this.basicGetLabel();
    }

    protected String basicGetObjectTip() {
        if (this.getObject() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getObject()).getTip();
        }
        return this.basicGetTip();
    }

    protected String basicGetTip() {
        return this.getLabel();
    }

    protected boolean basicHasChildren() {
        return this.cachedChildren == null || this.cachedChildren.length != 0;
    }

    protected void disarm() {
        if (this.object instanceof INotificationSupport) {
            ((INotificationSupport)this.object).removeNotificationListener(AttributeChangedEvent.ID, this.listenObjectChange);
            ((INotificationSupport)this.object).removeNotificationListener(DestroyedEvent.ID, this.listenObjectDestroy);
        }
    }

    protected void dispose() {
        this.disarm();
        this.disposeChildren();
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.clear();
        }
    }

    protected void disposeChildren() {
        if (this.cachedChildren == null) {
            return;
        }
        CommonNode<?>[] commonNodeArray = this.cachedChildren;
        int n = this.cachedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            CommonNode<?> child = commonNodeArray[n2];
            child.dispose();
            ++n2;
        }
        this.updateChildren();
    }

    @Override
    public synchronized Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(key);
    }

    public CommonNode<?>[] getChildren() {
        if (this.cachedChildren == null) {
            this.cachedChildren = this.nodeHandler == null ? this.basicCreateChildren() : this.nodeHandler.createChildren(this);
        }
        return this.cachedChildren;
    }

    @Override
    public String getDescription() {
        if (this.nodeHandler != null) {
            return this.nodeHandler.getDescription(this);
        }
        return this.basicGetObjectDescription();
    }

    @Override
    public String getIconName() {
        if (this.nodeHandler != null) {
            return this.nodeHandler.getIconName(this);
        }
        return this.basicGetObjectIconName();
    }

    @Override
    public String getLabel() {
        if (this.nodeHandler != null) {
            return this.nodeHandler.getLabel(this);
        }
        return this.basicGetObjectLabel();
    }

    public INodeHandler getNodeHandler() {
        return this.nodeHandler;
    }

    public T getObject() {
        return this.object;
    }

    public CommonNode<?> getParent() {
        return this.parent;
    }

    @Override
    public String getTip() {
        if (this.nodeHandler != null) {
            return this.nodeHandler.getTip(this);
        }
        return this.basicGetObjectTip();
    }

    public boolean hasChildren() {
        if (this.nodeHandler == null) {
            return this.basicHasChildren();
        }
        return this.nodeHandler.hasChildren(this);
    }

    protected boolean isReusable() {
        return true;
    }

    protected void onAttributeChanged(AttributeChangedEvent event) {
        this.triggerChange("label", null, null);
    }

    protected void onDestroy(Event event) {
        this.dispose();
    }

    protected void onEvent(Event event) {
        if (event instanceof AttributeChangedEvent) {
            this.onAttributeChanged((AttributeChangedEvent)event);
        }
    }

    @Override
    public synchronized Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.removeAttribute(key);
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public synchronized Object setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        return this.attributes.setAttribute(key, value);
    }

    public void setNodeHandler(INodeHandler nodeHandler) {
        this.nodeHandler = nodeHandler;
        this.unlinkChildren();
    }

    protected void triggerChange(Object attribute, Object oldValue, Object newValue) {
        this.eventDispatcher.triggerEvent(new AttributeChangedEvent(this, attribute, oldValue, newValue));
    }

    protected void unlink() {
        if (!this.isReusable()) {
            this.dispose();
        }
    }

    protected void unlinkChildren() {
        if (this.cachedChildren == null) {
            return;
        }
        CommonNode<?>[] commonNodeArray = this.cachedChildren;
        int n = this.cachedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            CommonNode<?> child = commonNodeArray[n2];
            child.unlink();
            ++n2;
        }
        this.updateChildren();
    }

    protected void updateChildren() {
        if (this.cachedChildren == null) {
            return;
        }
        this.cachedChildren = null;
        this.triggerChange("children", null, null);
    }
}

