/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tree;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tree.CommonNode;
import java.text.Format;

public class PropertyNode
extends CommonNode {
    private Format propertyFormat;
    private String propertyLabel;
    private String propertyName;
    private final boolean reusable;

    public PropertyNode(CommonNode parent, Object object, String label, String name, boolean reusable) {
        super(parent, object);
        this.propertyLabel = label;
        this.propertyName = name;
        this.reusable = reusable;
    }

    @Override
    public String getIconName() {
        return "icons/treenode_property";
    }

    @Override
    public String getLabel() {
        String valueLabel;
        Object value = this.getPropertyValue();
        if (this.propertyFormat != null) {
            try {
                valueLabel = this.propertyFormat.format(value);
            }
            catch (Exception e) {
                valueLabel = StringTools.safeString(value);
            }
        } else {
            valueLabel = value instanceof IPresentationSupport ? ((IPresentationSupport)value).getLabel() : StringTools.safeString(value);
        }
        return String.valueOf(this.getPropertyLabel()) + "=" + valueLabel;
    }

    public Format getPropertyFormat() {
        return this.propertyFormat;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        try {
            return ObjectTools.get(this.getObject(), this.getPropertyName());
        }
        catch (Exception e) {
            return "<not available>";
        }
    }

    @Override
    protected boolean isReusable() {
        return this.reusable;
    }

    @Override
    protected void onAttributeChanged(AttributeChangedEvent event) {
        String tempName;
        String string = tempName = event.getAttribute() instanceof String ? (String)event.getAttribute() : "?";
        if (this.propertyName.startsWith(tempName)) {
            super.onAttributeChanged(event);
        }
    }

    public void setPropertyFormat(Format propertyFormat) {
        this.propertyFormat = propertyFormat;
    }
}

