/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.PACKAGE;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class UIComponent<M, C, T>
implements IUIComponent<M, C, T>,
IElementConfigurable {
    private final EventDispatcher eventDispatcher = new EventDispatcher(this);
    private C container;
    private final IUIComponent parent;
    private T component;
    private IValueHolder<M> valueHolder;
    private static final Logger Log = PACKAGE.Log;
    private final INotificationListener listenModelChange = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            UIComponent.this.modelChanged(event);
        }
    };
    private IElement configuration;
    private boolean disposed = false;
    private boolean componentCreated = false;

    public UIComponent() {
        this(null);
    }

    public UIComponent(IUIComponent<?, C, T> parent) {
        this.parent = parent;
        this.valueHolder = parent == null ? new LocalValueHolder<Object>(null) : new InheritedValueHolder();
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    protected void basicAssociateComponent() {
    }

    protected abstract T basicCreateComponent(C var1);

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.configuration = element;
    }

    @Override
    public final void createComponent(C parent) {
        this.setContainer(parent);
        T tempComponent = this.basicCreateComponent(parent);
        this.setComponent(tempComponent);
        this.componentCreated = true;
        this.basicAssociateComponent();
        this.updateView(null);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.valueHolder instanceof IDisposable) {
            ((IDisposable)((Object)this.valueHolder)).dispose();
        }
        this.componentCreated = false;
    }

    @Override
    public final T getComponent() {
        return this.component;
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    protected C getContainer() {
        return this.container;
    }

    public IUIComponent getParent() {
        return this.parent;
    }

    @Override
    public synchronized M getValue() {
        return this.getValueHolder().get();
    }

    @Override
    public IValueHolder<M> getValueHolder() {
        return this.valueHolder;
    }

    protected void guiModelChanged(Event event) {
        try {
            if (!this.isComponentCreated()) {
                return;
            }
            this.updateView(event);
        }
        catch (Exception e) {
            Log.log(Level.WARNING, "unexpeced error in updateView", e);
        }
    }

    protected boolean isComponentCreated() {
        return this.componentCreated;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected void modelChanged(final Event event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIComponent.this.guiModelChanged(event);
            }
        });
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    protected void setComponent(T component) {
        this.component = component;
    }

    protected void setComponentCreated(boolean componentAvailable) {
        this.componentCreated = componentAvailable;
    }

    protected void setContainer(C parent) {
        this.container = parent;
    }

    @Override
    public synchronized M setValue(M value) {
        return this.getValueHolder().set(value);
    }

    public void setValueHolder(IValueHolder<M> pValueHolder) {
        if (this.valueHolder == pValueHolder) {
            return;
        }
        if (this.valueHolder instanceof IDisposable) {
            ((IDisposable)((Object)this.valueHolder)).dispose();
        }
        this.valueHolder = pValueHolder;
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.triggerEvent(event);
    }

    protected void updateView(Event e) {
    }

    class InheritedValueHolder
    implements IValueHolder<M>,
    IDisposable {
        private final INotificationListener listenParentChange = new INotificationListener(){

            @Override
            public void handleEvent(Event event) {
                InheritedValueHolder.this.onParentChange((AttributeChangedEvent)event);
            }
        };

        public InheritedValueHolder() {
            UIComponent.this.getParent().addNotificationListener(AttributeChangedEvent.ID, this.listenParentChange);
            if (UIComponent.this.getParent().getValue() instanceof INotificationSupport) {
                ((INotificationSupport)UIComponent.this.getParent().getValue()).addNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
        }

        @Override
        public void dispose() {
            UIComponent.this.getParent().removeNotificationListener(AttributeChangedEvent.ID, this.listenParentChange);
            if (UIComponent.this.getParent().getValue() instanceof INotificationSupport) {
                ((INotificationSupport)UIComponent.this.getParent().getValue()).removeNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
        }

        @Override
        public M get() {
            IUIComponent parent = UIComponent.this.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getValue();
        }

        @Override
        public boolean isDisposed() {
            return UIComponent.this.disposed;
        }

        protected void onParentChange(AttributeChangedEvent event) {
            if (event.getOldValue() instanceof INotificationSupport) {
                ((INotificationSupport)event.getOldValue()).removeNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
            if (event.getNewValue() instanceof INotificationSupport) {
                ((INotificationSupport)event.getNewValue()).addNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
            UIComponent.this.modelChanged(event);
            UIComponent.this.triggerEvent(event);
        }

        @Override
        public M set(M newValue) {
            UIComponent.this.setValueHolder(new LocalValueHolder<Object>(null));
            return UIComponent.this.setValue(newValue);
        }
    }

    class LocalValueHolder<T>
    implements IValueHolder<T>,
    IDisposable {
        private T value;

        public LocalValueHolder(T value) {
            this.set(value);
        }

        @Override
        public void dispose() {
            if (this.value instanceof INotificationSupport) {
                ((INotificationSupport)this.value).removeNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isDisposed() {
            return UIComponent.this.disposed;
        }

        @Override
        public T set(T newValue) {
            T oldValue = this.value;
            if (oldValue == newValue) {
                return this.value;
            }
            if (oldValue instanceof INotificationSupport) {
                ((INotificationSupport)oldValue).removeNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
            if (newValue instanceof INotificationSupport) {
                ((INotificationSupport)newValue).addNotificationListener(AttributeChangedEvent.ID, UIComponent.this.listenModelChange);
            }
            this.value = newValue;
            if (this.value != null) {
                UIComponent.this.modelChanged(new AttributeChangedEvent(this.value, null, null, null));
            }
            UIComponent.this.triggerEvent(new AttributeChangedEvent(UIComponent.this, "value", oldValue, newValue));
            return oldValue;
        }
    }
}

