/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.UIComponent;
import java.util.ArrayList;
import java.util.List;

public abstract class UIWizard<M, C, T>
extends UIComponent<M, C, T> {
    private List<IUIComponent<M, C, T>> pages = new ArrayList<IUIComponent<M, C, T>>();
    private IUIComponent<M, C, T> currentPage;

    public UIWizard(IUIComponent parent) {
        super(parent);
        this.initPages();
    }

    protected void activatePage(IUIComponent<M, C, T> page) {
        if (page == this.currentPage) {
            return;
        }
        if (this.currentPage != null) {
            this.removePage(this.currentPage);
        }
        this.currentPage = page;
        this.currentPage.createComponent(this.getComponent());
    }

    protected void addPage(IUIComponent<M, C, T> page) {
        this.pages.add(page);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        for (IUIComponent<M, C, T> page : this.pages) {
            if (!(page instanceof IElementConfigurable)) continue;
            ((IElementConfigurable)((Object)page)).configure(element);
        }
    }

    @Override
    public void dispose() {
        for (IUIComponent<M, C, T> page : this.pages) {
            page.dispose();
        }
        super.dispose();
    }

    public IUIComponent<M, C, T> getCurrentPage() {
        return this.currentPage;
    }

    protected void initPages() {
    }

    public boolean isNextEnabled() {
        return this.selectNextPage() != this.currentPage;
    }

    public boolean isPreviousEnabled() {
        return this.selectPreviousPage() != this.currentPage;
    }

    protected boolean isVisible(IUIComponent<M, C, T> page) {
        return true;
    }

    public void onNextPressed() {
        this.activatePage(this.selectNextPage());
    }

    public void onPreviousPressed() {
        this.activatePage(this.selectPreviousPage());
    }

    protected void removePage(IUIComponent<M, C, T> currentPage2) {
    }

    protected IUIComponent<M, C, T> selectInitialPage() {
        return this.selectNextPage(-1);
    }

    protected IUIComponent<M, C, T> selectNextPage() {
        int index = this.pages.indexOf(this.currentPage);
        return this.selectNextPage(index);
    }

    protected IUIComponent<M, C, T> selectNextPage(int index) {
        IUIComponent<M, C, T> newPage = this.currentPage;
        ++index;
        while (index < this.pages.size()) {
            IUIComponent<M, C, T> tempPage = this.pages.get(index);
            if (this.isVisible(tempPage)) {
                return tempPage;
            }
            ++index;
        }
        return newPage;
    }

    protected IUIComponent<M, C, T> selectPreviousPage() {
        int index = this.pages.indexOf(this.currentPage);
        return this.selectPreviousPage(index);
    }

    protected IUIComponent<M, C, T> selectPreviousPage(int index) {
        IUIComponent<M, C, T> newPage = this.currentPage;
        --index;
        while (index >= 0) {
            IUIComponent<M, C, T> tempPage = this.pages.get(index);
            if (this.isVisible(tempPage)) {
                return tempPage;
            }
            --index;
        }
        return newPage;
    }

    protected void setCurrentPage(IUIComponent<M, C, T> currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    protected void updateView(Event e) {
        super.updateView(e);
        if (this.currentPage == null) {
            IUIComponent<M, C, T> nextPage = this.selectInitialPage();
            this.activatePage(nextPage);
        }
    }
}

