/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.url;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class URLEncodingTools {
    public static final String CHARSET_DEFAULT = "ISO_8859_1";

    protected static String decode(String value, String encoding) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, encoding != null ? encoding : CHARSET_DEFAULT);
    }

    public static Map<String, String> decodeEntity(String content, String encoding) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Scanner scanner = new Scanner(content);
        scanner.useDelimiter("&");
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split("=");
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name = URLEncodingTools.decode(nameValue[0], encoding);
            String value = "";
            if (nameValue.length == 2) {
                value = URLEncodingTools.decode(nameValue[1], encoding);
            }
            parameters.put(name, value);
        }
        return parameters;
    }

    protected static String encode(String value, String encoding) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, encoding != null ? encoding : CHARSET_DEFAULT);
    }

    public static String encodeEntity(Map<String, String> parameters, String encoding) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String encodedValue;
            String encodedName = URLEncodingTools.encode(parameter.getKey(), encoding);
            String value = parameter.getValue();
            String string = encodedValue = value != null ? URLEncodingTools.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }
}

