/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.validation;

import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import java.util.ArrayList;
import java.util.List;

public class ValidationResult
implements INoticesSupport {
    private final Object target;
    private final long timestamp;
    private boolean hasInfo = false;
    private boolean hasError = false;
    private boolean hasWarning = false;
    private final List<Notice> notices = new ArrayList<Notice>();

    public ValidationResult(Object target) {
        this.target = target;
        this.timestamp = System.currentTimeMillis();
    }

    public void addError(String text, Object detail) {
        Notice note = new Notice(30, text, detail, true);
        this.addNotice(note);
    }

    public void addInfo(String text, Object detail) {
        Notice note = new Notice(10, text, detail, true);
        this.addNotice(note);
    }

    public void addNotice(int severity, String text, Object detail, boolean sticky) {
        Notice note = new Notice(severity, text, detail, sticky);
        this.addNotice(note);
    }

    @Override
    public void addNotice(Notice notification) {
        this.notices.add(notification);
        this.hasInfo |= notification.isInfo();
        this.hasWarning |= notification.isWarning();
        this.hasError |= notification.isError();
    }

    public void addNotices(INoticesSupport ns) {
        for (Notice notice : ns.getNotices()) {
            this.addNotice(notice);
        }
    }

    public void addWarning(String text, Object detail) {
        Notice note = new Notice(20, text, detail, true);
        this.addNotice(note);
    }

    @Override
    public void clearNotices() {
        this.notices.clear();
    }

    @Override
    public List<Notice> getNotices() {
        return this.notices;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        for (Notice note : this.notices) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(note.getText());
        }
        return sb.toString();
    }

    public Object getTarget() {
        return this.target;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public boolean hasNotices() {
        return this.notices.size() > 0;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    @Override
    public boolean removeNotice(Notice notice) {
        return this.notices.remove(notice);
    }
}

