/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.CMapEncoding;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.IdentityCMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PDFontType0
extends PDFont {
    public static final COSName DK_DescendantFonts = COSName.constant("DescendantFonts");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CMap cachedMap;
    private Map<Integer, PDGlyphs> cachedGlyphs = new HashMap<Integer, PDGlyphs>();

    public PDFontType0(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type0;
    }

    @Override
    protected Encoding createEncoding() {
        CMap cMap = this.getCMap();
        return new CMapEncoding(cMap);
    }

    public CMap getCMap() {
        if (this.cachedMap == null) {
            this.cachedMap = (CMap)CMap.META.createFromCos(this.cosGetField(DK_Encoding));
        }
        return this.cachedMap;
    }

    public CIDFont getDescendantFont() {
        COSArray cOSArray = this.cosGetField(DK_DescendantFonts).asArray();
        if (cOSArray == null || cOSArray.size() == 0) {
            return null;
        }
        COSObject cOSObject = cOSArray.get(0);
        return (CIDFont)PDFont.META.createFromCos(cOSObject);
    }

    @Override
    public PDFontDescriptor getFontDescriptor() {
        return this.getDescendantFont().getFontDescriptor();
    }

    @Override
    public String getFontFamilyName() {
        return this.getDescendantFont().getFontFamilyName();
    }

    @Override
    public String getFontName() {
        return this.getDescendantFont().getFontName();
    }

    @Override
    public String getFontNameNormalized() {
        return this.getDescendantFont().getFontNameNormalized();
    }

    @Override
    public PDFontStyle getFontStyle() {
        return this.getDescendantFont().getFontStyle();
    }

    @Override
    public String getFontType() {
        return this.getDescendantFont().getFontType();
    }

    public int getGlyphIndex(int n) {
        return this.getDescendantFont().getGlyphIndex(n);
    }

    @Override
    public PDGlyphs getGlyphsEncoded(int n) {
        PDGlyphs pDGlyphs = this.cachedGlyphs.get(n);
        if (pDGlyphs == null) {
            pDGlyphs = new PDGlyphs(this, n);
            this.cachedGlyphs.put(n, pDGlyphs);
        }
        return pDGlyphs;
    }

    @Override
    public int getGlyphWidthEncoded(int n) {
        int n2 = this.getCMap().getDecoded(n);
        if (n2 == -1) {
            return 0;
        }
        return this.getDescendantFont().getGlyphWidthCID(n2);
    }

    @Override
    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream byteArrayInputStream) throws IOException {
        int n = this.getCMap().getNextEncoded(byteArrayInputStream);
        if (n == -1) {
            return null;
        }
        return this.getGlyphsEncoded(n);
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(PDFont.DK_Encoding, IdentityCMap.CN_Identity_H);
    }

    public void setDescendantFont(CIDFont cIDFont) {
        if (cIDFont == null) {
            this.cosRemoveField(DK_DescendantFonts);
            return;
        }
        COSArray cOSArray = this.cosGetField(DK_DescendantFonts).asArray();
        if (cOSArray == null) {
            cOSArray = COSArray.create();
            this.cosSetField(DK_DescendantFonts, cOSArray);
        }
        if (cOSArray.size() == 0) {
            cOSArray.add(cIDFont.cosGetObject());
        } else {
            cOSArray.set(0, cIDFont.cosGetObject());
        }
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFontType0(cOSObject);
        }
    }
}

