/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPopupAnnotation;

public class PDMarkupAnnotation
extends PDAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_CreationDate = COSName.constant("CreationDate");
    public static final COSName DK_Subj = COSName.constant("Subj");
    public static final COSName DK_T = COSName.constant("T");
    public static final COSName DK_Popup = COSName.constant("Popup");
    public static final COSName DK_CA = COSName.constant("CA");
    public static final COSName DK_L = COSName.constant("L");
    public static final COSName DK_RC = COSName.constant("RC");
    public static final COSName DK_Vertices = COSName.constant("Vertices");
    public static final COSName CN_Subtype_Ink = COSName.constant("Ink");
    public static final COSName CN_Subtype_Square = COSName.constant("Square");
    public static final COSName CN_Subtype_Circle = COSName.constant("Circle");
    public static final COSName CN_Subtype_Line = COSName.constant("Line");
    public static final COSName CN_Subtype_Polygon = COSName.constant("Polygon");
    public static final COSName CN_Subtype_PolyLine = COSName.constant("PolyLine");
    public static final COSName DK_InkList = COSName.constant("InkList");
    public static final COSName DK_IC = COSName.constant("IC");
    public static final COSName DK_IRT = COSName.constant("IRT");

    protected PDMarkupAnnotation(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    public COSObject cosSetField(COSName cOSName, COSObject cOSObject) {
        if (!DK_M.equals(cOSName)) {
            this.touch();
        }
        return super.cosSetField(cOSName, cOSObject);
    }

    public CDSDate getCreationDate() {
        return CDSDate.createFromCOS(this.cosGetField(DK_CreationDate).asString());
    }

    public float[] getInnerColor() {
        return this.getFieldFixedArray(DK_IC, null);
    }

    public PDAnnotation getInReplyTo() {
        return (PDAnnotation)PDAnnotation.META.createFromCos(this.cosGetField(DK_IRT));
    }

    public double getOpacity() {
        return this.getFieldFixed(DK_CA, 1.0f);
    }

    public PDAnnotation getPopup() {
        return (PDAnnotation)PDAnnotation.META.createFromCos(this.cosGetField(DK_Popup));
    }

    public String getRichContent() {
        return this.getFieldString(DK_RC, "");
    }

    public String getSubject() {
        return this.getFieldString(DK_Subj, "");
    }

    @Override
    public String getSubtypeLabel() {
        if (CN_Subtype_Circle.equals(this.cosGetSubtype())) {
            return "Circle";
        }
        if (CN_Subtype_Ink.equals(this.cosGetSubtype())) {
            return "Freehand";
        }
        if (CN_Subtype_Line.equals(this.cosGetSubtype())) {
            return "Line";
        }
        if (CN_Subtype_Polygon.equals(this.cosGetSubtype())) {
            return "Polygon";
        }
        if (CN_Subtype_PolyLine.equals(this.cosGetSubtype())) {
            return "Polyline";
        }
        if (CN_Subtype_Square.equals(this.cosGetSubtype())) {
            return "Square";
        }
        return "Annotation";
    }

    public String getText() {
        return this.getFieldString(DK_T, "");
    }

    @Override
    public boolean isMarkupAnnotation() {
        return true;
    }

    public void setInnerColor(float[] fArray) {
        this.setFieldFixedArray(DK_IC, fArray);
    }

    public void setOpacity(float f) {
        this.setFieldFixed(DK_CA, f);
    }

    public void setPopup(PDPopupAnnotation pDPopupAnnotation) {
        this.setFieldObject(DK_Popup, pDPopupAnnotation);
    }

    public void setSubject(String string) {
        this.setFieldString(DK_Subj, string);
    }

    public void setText(String string) {
        this.setFieldString(DK_T, string);
    }

    public static class MetaClass
    extends PDAnnotation.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDMarkupAnnotation(cOSObject);
        }
    }
}

