/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.IdentityAppearanceCreator;
import de.intarsys.pdf.app.appearance.NullAppearanceCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.attribute.Attribute;

public class AppearanceCreatorTools {
    private static final Attribute ATTR_APPEARANCECREATOR = new Attribute("appearanceCreator");
    private static final Attribute ATTR_PREVIOUSAPPEARANCECREATOR = new Attribute("previousAppearanceCreator");
    private static final IAppearanceCreator APPEARANCECREATOR_IDENTITY = new IdentityAppearanceCreator();
    private static final IAppearanceCreator APPEARANCECREATOR_NULL = new NullAppearanceCreator();

    public static void createAppearance(PDAcroFormField field) {
        IAppearanceCreator appearanceCreator = AppearanceCreatorTools.getAppearanceCreator(field);
        for (PDAnnotation annot : field.getLogicalRoot().getAnnotations()) {
            AppearanceCreatorTools.createAppearance(annot, appearanceCreator);
        }
    }

    public static PDAppearance createAppearance(PDAnnotation annotation) {
        IAppearanceCreator appearanceCreator = AppearanceCreatorTools.getAppearanceCreator(annotation);
        return AppearanceCreatorTools.createAppearance(annotation, appearanceCreator);
    }

    public static PDAppearance createAppearance(PDAnnotation annotation, IAppearanceCreator appearanceCreator) {
        PDAppearance appearance;
        if (appearanceCreator == null) {
            COSName type = annotation.cosGetSubtype();
            appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(type);
            if (appearanceCreator == null) {
                appearanceCreator = APPEARANCECREATOR_NULL;
            }
        }
        if ((appearance = appearanceCreator.createAppearance(annotation, null)) != annotation.getAppearance()) {
            annotation.setAppearance(appearance);
        }
        return appearance;
    }

    public static IAppearanceCreator getAppearanceCreator(PDObject fieldOrAnntotation) {
        return (IAppearanceCreator)fieldOrAnntotation.getAttribute(ATTR_APPEARANCECREATOR);
    }

    public static void resumeAppearanceCreation(PDObject fieldOrAnntotation) {
        IAppearanceCreator previousAppearanceCreator = (IAppearanceCreator)fieldOrAnntotation.removeAttribute(ATTR_PREVIOUSAPPEARANCECREATOR);
        AppearanceCreatorTools.setAppearanceCreator(fieldOrAnntotation, previousAppearanceCreator);
    }

    public static void setAppearanceCreator(PDObject fieldOrAnntotation, IAppearanceCreator appearanceCreator) {
        fieldOrAnntotation.setAttribute(ATTR_APPEARANCECREATOR, appearanceCreator);
    }

    public static void suspendAppearanceCreation(PDObject fieldOrAnntotation) {
        IAppearanceCreator currentAppearanceCreator = AppearanceCreatorTools.getAppearanceCreator(fieldOrAnntotation);
        fieldOrAnntotation.setAttribute(ATTR_PREVIOUSAPPEARANCECREATOR, currentAppearanceCreator);
        AppearanceCreatorTools.setAppearanceCreator(fieldOrAnntotation, APPEARANCECREATOR_IDENTITY);
    }
}

