/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.IAppearanceCreatorRegistry;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardAppearanceCreatorRegistry
implements IAppearanceCreatorRegistry {
    private Map<COSName, IAppearanceCreator> instances = new HashMap<COSName, IAppearanceCreator>();
    private boolean initialized = false;
    private boolean lookupProviders = true;
    private static final Logger Log = Logger.getLogger("de.intarsys.pdf.app.appearance");

    protected StandardAppearanceCreatorRegistry() {
    }

    protected IAppearanceCreator[] findProviders() {
        ArrayList<IAppearanceCreator> result = new ArrayList<IAppearanceCreator>();
        Iterator ps = ProviderTools.providers(IAppearanceCreator.class);
        while (ps.hasNext()) {
            try {
                result.add((IAppearanceCreator)ps.next());
            }
            catch (Throwable e) {
                Log.log(Level.WARNING, "can't load service provider (" + e.getMessage() + ")");
            }
        }
        return result.toArray(new IAppearanceCreator[result.size()]);
    }

    @Override
    public synchronized IAppearanceCreator[] getAppearanceCreators() {
        this.init();
        return this.instances.values().toArray(new IAppearanceCreator[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAppearanceCreator[] providers = this.findProviders();
        int i = 0;
        while (i < providers.length) {
            IAppearanceCreator provider = providers[i];
            this.registerAppearanceCreator(provider);
            ++i;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IAppearanceCreator lookupAppearanceCreator(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    @Override
    public synchronized void registerAppearanceCreator(IAppearanceCreator creator) {
        this.instances.put(creator.getAnnotationType(), creator);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterAppearanceCreator(IAppearanceCreator creator) {
        this.instances.remove(creator.getAnnotationType());
    }
}

