/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.date.DateEnvironment;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDSDate
extends CDSBase {
    public static final String DATE_FORMAT = "'D':yyyyMMddHHmmss";
    public static final Pattern DatePattern = Pattern.compile("D:(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\+|-|Z|z)?(\\d{2})?\\'?(\\d{2})?.*");
    private static final DateFormat PDF_DATE_FORMAT = new SimpleDateFormat("'D':yyyyMMddHHmmss");
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    public static CDSDate createFromCOS(COSString string) {
        if (string == null) {
            return null;
        }
        return new CDSDate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(CDSDate cdsDate) {
        DateFormat dateFormat = CDSDate.dateFormat;
        synchronized (dateFormat) {
            return CDSDate.format(CDSDate.dateFormat, cdsDate);
        }
    }

    public static String format(Format format, CDSDate cdsDate) {
        String strDate = "";
        if (cdsDate != null) {
            try {
                strDate = format.format(cdsDate.toDate());
            }
            catch (ParseException e) {
                strDate = cdsDate.toString();
            }
        }
        return strDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String string) throws ParseException {
        DateFormat dateFormat = PDF_DATE_FORMAT;
        synchronized (dateFormat) {
            return PDF_DATE_FORMAT.parse(string);
        }
    }

    public static Date toDateWithZone(String string) throws ParseException {
        Matcher m = DatePattern.matcher(string);
        if (m.matches()) {
            int year = Integer.valueOf(m.group(1));
            int month = Integer.valueOf(m.group(2)) - 1;
            int day = Integer.valueOf(m.group(3));
            int hour = Integer.valueOf(m.group(4));
            int min = Integer.valueOf(m.group(5));
            int sec = Integer.valueOf(m.group(6));
            int hourOffset = 0;
            int minOffset = 0;
            if (m.group(9) != null) {
                minOffset = Integer.valueOf(m.group(9));
            }
            if (m.group(8) != null) {
                hourOffset = Integer.valueOf(m.group(8));
            }
            if (m.group(7) != null) {
                String o = m.group(7);
                if (o.toLowerCase().equals("z")) {
                    hourOffset = 0;
                    minOffset = 0;
                } else if ("-".equals(o)) {
                    hourOffset *= -1;
                    minOffset *= -1;
                }
                hour -= hourOffset;
                min -= minOffset;
            }
            int offset = TimeZone.getDefault().getOffset(System.currentTimeMillis());
            boolean nowDST = TimeZone.getDefault().inDaylightTime(DateEnvironment.get().now());
            GregorianCalendar testDate = new GregorianCalendar(year, month, day);
            boolean testDST = TimeZone.getDefault().inDaylightTime(testDate.getTime());
            if (nowDST) {
                if (!testDST) {
                    offset -= TimeZone.getDefault().getDSTSavings();
                }
            } else if (testDST) {
                offset += TimeZone.getDefault().getDSTSavings();
            }
            hourOffset = Math.abs((offset /= 60000) / 60);
            minOffset = offset % 60;
            if (offset < 0) {
                hour -= hourOffset;
                min -= minOffset;
            } else {
                hour += hourOffset;
                min += minOffset;
            }
            GregorianCalendar greg = new GregorianCalendar(year, month, day, hour, min, sec);
            return greg.getTime();
        }
        throw new ParseException("can't parse date string '" + string + "'", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date date) {
        DateFormat dateFormat = PDF_DATE_FORMAT;
        synchronized (dateFormat) {
            return PDF_DATE_FORMAT.format(date);
        }
    }

    public static String toStringWithZone(Date date) {
        return CDSDate.toStringWithZone(date, TimeZone.getDefault());
    }

    public static String toStringWithZone(Date date, TimeZone timeZone) {
        StringBuilder result = new StringBuilder();
        result.append(CDSDate.toString(date));
        int offset = timeZone.getOffset(date.getTime());
        if (offset < 0) {
            result.append("-");
        } else if (offset > 0) {
            result.append("+");
        } else {
            result.append("Z");
        }
        int hours = Math.abs(offset / 3600000);
        if (hours / 10 < 1) {
            result.append("0");
        }
        result.append(hours);
        result.append("'00'");
        return result.toString();
    }

    public CDSDate() {
        super(COSString.create(CDSDate.toStringWithZone(DateEnvironment.get().now())));
    }

    protected CDSDate(COSString newDateString) {
        super(newDateString);
    }

    public String stringValue() {
        return ((COSString)this.cosGetObject()).stringValue();
    }

    public Date toDate() throws ParseException {
        return CDSDate.toDateWithZone(this.stringValue());
    }

    public String toFormattedString() {
        return CDSDate.format(this);
    }
}

