/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSNumber;
import java.awt.geom.AffineTransform;

public class CDSMatrix
extends CDSBase {
    public static float[] MATRIX_0 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    public static float[] MATRIX_90 = new float[]{0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f};
    public static float[] MATRIX_180 = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
    public static float[] MATRIX_270 = new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private float a;
    private float b;
    private float c;
    private float d;
    private float e;
    private float f;

    public static CDSMatrix createFromCOS(COSArray array) {
        if (array == null) {
            return null;
        }
        CDSMatrix matrix = (CDSMatrix)array.getAttribute(CDSMatrix.class);
        if (matrix == null) {
            matrix = new CDSMatrix(array);
            array.setAttribute(CDSMatrix.class, matrix);
        }
        return matrix;
    }

    public CDSMatrix() {
        super(COSArray.createWith(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 1.0f;
        this.e = 0.0f;
        this.f = 0.0f;
    }

    protected CDSMatrix(COSArray newM) {
        super(newM);
        this.a = this.getA();
        this.b = this.getB();
        this.c = this.getC();
        this.d = this.getD();
        this.e = this.getE();
        this.f = this.getF();
    }

    public CDSMatrix(float a, float b, float c, float d, float e, float f) {
        super(COSArray.createWith(a, b, c, d, e, f));
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
    }

    public CDSMatrix(float[] data) {
        super(COSArray.createWith(data[0], data[1], data[2], data[3], data[4], data[5]));
        this.a = data[0];
        this.b = data[1];
        this.c = data[2];
        this.d = data[3];
        this.e = data[4];
        this.f = data[5];
    }

    public CDSMatrix copy() {
        CDSMatrix result = new CDSMatrix((COSArray)this.cosGetObject().copyShallow());
        return result;
    }

    public float getA() {
        return ((COSNumber)this.cosGetArray().get(0)).floatValue();
    }

    public float getB() {
        return ((COSNumber)this.cosGetArray().get(1)).floatValue();
    }

    public float getC() {
        return ((COSNumber)this.cosGetArray().get(2)).floatValue();
    }

    public float getD() {
        return ((COSNumber)this.cosGetArray().get(3)).floatValue();
    }

    public float getE() {
        return ((COSNumber)this.cosGetArray().get(4)).floatValue();
    }

    public float getF() {
        return ((COSNumber)this.cosGetArray().get(5)).floatValue();
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.a = this.getA();
        this.b = this.getB();
        this.c = this.getC();
        this.d = this.getD();
        this.e = this.getE();
        this.f = this.getF();
    }

    public void rotate(float angle) {
        AffineTransform transform = this.toTransform();
        transform.rotate(angle);
        this.setTransformation(transform);
    }

    public void scale(float sx, float sy) {
        this.setA(this.getA() * sx);
        this.setB(this.getB() * sx);
        this.setC(this.getC() * sy);
        this.setD(this.getD() * sy);
    }

    public void scale(float[] v) {
        this.setA(this.getA() * v[0]);
        this.setB(this.getB() * v[0]);
        this.setC(this.getC() * v[1]);
        this.setD(this.getD() * v[1]);
    }

    public void setA(float num) {
        this.cosGetArray().set(0, COSFixed.create(num));
    }

    public void setB(float num) {
        this.cosGetArray().set(1, COSFixed.create(num));
    }

    public void setC(float num) {
        this.cosGetArray().set(2, COSFixed.create(num));
    }

    public void setD(float num) {
        this.cosGetArray().set(3, COSFixed.create(num));
    }

    public void setE(float num) {
        this.cosGetArray().set(4, COSFixed.create(num));
    }

    public void setF(float num) {
        this.cosGetArray().set(5, COSFixed.create(num));
    }

    public void setTransformation(AffineTransform transform) {
        double[] data = new double[6];
        transform.getMatrix(data);
        this.cosGetArray().set(0, COSFixed.create(data[0]));
        this.cosGetArray().set(1, COSFixed.create(data[1]));
        this.cosGetArray().set(2, COSFixed.create(data[2]));
        this.cosGetArray().set(3, COSFixed.create(data[3]));
        this.cosGetArray().set(4, COSFixed.create(data[4]));
        this.cosGetArray().set(5, COSFixed.create(data[5]));
    }

    public void setTransformation(float a, float b, float c, float d, float e, float f) {
        this.cosGetArray().set(0, COSFixed.create(a));
        this.cosGetArray().set(1, COSFixed.create(b));
        this.cosGetArray().set(2, COSFixed.create(c));
        this.cosGetArray().set(3, COSFixed.create(d));
        this.cosGetArray().set(4, COSFixed.create(e));
        this.cosGetArray().set(5, COSFixed.create(f));
    }

    public void setTransformation(float[] data) {
        this.cosGetArray().set(0, COSFixed.create(data[0]));
        this.cosGetArray().set(1, COSFixed.create(data[1]));
        this.cosGetArray().set(2, COSFixed.create(data[2]));
        this.cosGetArray().set(3, COSFixed.create(data[3]));
        this.cosGetArray().set(4, COSFixed.create(data[4]));
        this.cosGetArray().set(5, COSFixed.create(data[5]));
    }

    public AffineTransform toTransform() {
        return new AffineTransform(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public float[] transform(float[] v) {
        int len = v.length;
        float[] result = new float[len];
        int i = 0;
        int iinc = 1;
        while (iinc < len) {
            result[i] = this.a * v[i] + this.c * v[iinc] + this.e;
            result[iinc] = this.b * v[i] + this.d * v[iinc] + this.f;
            i += 2;
            iinc += 2;
        }
        return result;
    }

    public void translate(float x, float y) {
        this.setE(this.getE() + x * this.getA() + y * this.getB());
        this.setF(this.getF() + x * this.getC() + y * this.getD());
    }

    public void translate(float[] v) {
        this.setE(this.getE() + v[0] * this.getA() + v[1] * this.getB());
        this.setF(this.getF() + v[0] * this.getC() + v[1] * this.getD());
    }
}

