/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CDSNameTreeNode
extends CDSTreeNode {
    public static final COSName DK_Names = COSName.constant("Names");

    public static CDSNameTreeNode createFromCos(COSDictionary node) {
        if (node == null) {
            return null;
        }
        return new CDSNameTreeNode(node);
    }

    public static CDSTreeNode createIntermediate() {
        CDSNameTreeNode result = new CDSNameTreeNode(COSDictionary.create());
        result.createLimits();
        result.createKids();
        return result;
    }

    public static CDSNameTreeNode createLeaf() {
        CDSNameTreeNode result = new CDSNameTreeNode(COSDictionary.create());
        result.createLimits();
        result.createNames();
        return result;
    }

    public static CDSNameTreeNode createRootIntermediate() {
        CDSNameTreeNode result = new CDSNameTreeNode(COSDictionary.create());
        result.createKids();
        return result;
    }

    public static CDSNameTreeNode createRootLeaf() {
        CDSNameTreeNode result = new CDSNameTreeNode(COSDictionary.create());
        result.createNames();
        return result;
    }

    protected CDSNameTreeNode(COSDictionary dict) {
        super(dict);
    }

    public void addAll(CDSNameTreeNode node) {
        Iterator i = node.iterator();
        while (i.hasNext()) {
            CDSNameTreeEntry entry = (CDSNameTreeEntry)i.next();
            COSString name = (COSString)entry.getName().copyOptional();
            COSObject value = entry.getValue().copyOptional();
            this.put(name, value);
        }
    }

    protected void checkLimits() {
        if (this.getLimits() == null || this.getLimits().size() != 2) {
            this.createLimits();
            this.updateLimits();
        }
    }

    public boolean contains(COSString name) {
        if (!this.mayContain(name)) {
            return false;
        }
        List tempKids = this.getKids();
        if (tempKids != null) {
            for (CDSNameTreeNode node : tempKids) {
                if (!node.contains(name)) continue;
                return true;
            }
            return false;
        }
        List tempEntries = this.getEntries();
        if (tempEntries != null) {
            for (CDSNameTreeEntry entry : tempEntries) {
                int c = entry.getName().compareTo(name);
                if (c == 0) {
                    return true;
                }
                if (c <= 0) continue;
                return false;
            }
        }
        return false;
    }

    protected void createKids() {
        COSArray array = COSArray.create();
        this.cosGetDict().put(DK_Kids, array);
    }

    protected void createLimits() {
        COSArray array = COSArray.create(2);
        array.add(COSNull.create());
        array.add(COSNull.create());
        this.cosGetDict().put(DK_Limits, array);
    }

    protected void createNames() {
        COSArray array = COSArray.create();
        this.cosGetDict().put(DK_Names, array);
    }

    public COSObject get(COSString name) {
        if (!this.mayContain(name)) {
            return COSNull.NULL;
        }
        List tempKids = this.getKids();
        if (tempKids != null) {
            for (CDSNameTreeNode node : tempKids) {
                COSObject result = node.get(name);
                if (result.isNull()) continue;
                return result;
            }
            return COSNull.NULL;
        }
        List tempEntries = this.getEntries();
        if (tempEntries != null) {
            for (CDSNameTreeEntry entry : tempEntries) {
                int c = entry.getName().compareTo(name);
                if (c == 0) {
                    return entry.getValue();
                }
                if (c <= 0) continue;
                return COSNull.NULL;
            }
        }
        return COSNull.NULL;
    }

    public List getEntries() {
        COSArray cosNames;
        if (this.entries == null && (cosNames = this.cosGetDict().get(DK_Names).asArray()) != null) {
            this.entries = new ArrayList();
            Iterator<COSObject> i = cosNames.iterator();
            while (i.hasNext()) {
                COSString name = i.next().asString();
                if (!i.hasNext()) break;
                COSObject value = i.next();
                if (name == null) continue;
                CDSNameTreeEntry entry = new CDSNameTreeEntry(name, value);
                this.entries.add(entry);
            }
        }
        return this.entries;
    }

    public List getKids() {
        COSArray cosKids;
        if (this.kids == null && (cosKids = this.cosGetDict().get(DK_Kids).asArray()) != null) {
            this.kids = new ArrayList();
            Iterator<COSObject> i = cosKids.iterator();
            while (i.hasNext()) {
                COSDictionary dict = i.next().asDictionary();
                if (dict == null) continue;
                CDSNameTreeNode kid = CDSNameTreeNode.createFromCos(dict);
                this.kids.add(kid);
            }
        }
        return this.kids;
    }

    public COSArray getLimits() {
        if (this.limits == null) {
            this.limits = this.cosGetDict().get(DK_Limits).asArray();
        }
        return this.limits;
    }

    public COSString getMax() {
        if (this.getLimits() != null) {
            return this.getLimits().get(1).asString();
        }
        return null;
    }

    public COSString getMin() {
        if (this.getLimits() != null) {
            return this.getLimits().get(0).asString();
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return this.cosGetDict().containsKey(DK_Names);
    }

    public Iterator iterator() {
        List tempKids = this.getKids();
        if (tempKids != null) {
            return new Iterator(){
                private final Iterator thisIterator;
                private Iterator childIterator;
                {
                    this.thisIterator = CDSNameTreeNode.this.getKids().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.childIterator != null && this.childIterator.hasNext()) {
                        return true;
                    }
                    if (this.thisIterator.hasNext()) {
                        CDSNameTreeNode current = (CDSNameTreeNode)this.thisIterator.next();
                        this.childIterator = current.iterator();
                        return this.hasNext();
                    }
                    return false;
                }

                public Object next() {
                    if (this.childIterator != null && this.childIterator.hasNext()) {
                        return this.childIterator.next();
                    }
                    if (this.thisIterator.hasNext()) {
                        CDSNameTreeNode current = (CDSNameTreeNode)this.thisIterator.next();
                        this.childIterator = current.iterator();
                        return this.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        List tempEntries = this.getEntries();
        if (tempEntries != null) {
            return tempEntries.iterator();
        }
        return Collections.emptyIterator();
    }

    public boolean mayContain(COSString name) {
        if (this.getMin() == null || this.getMax() == null) {
            return true;
        }
        if (name.compareTo(this.getMin()) < 0) {
            return false;
        }
        return name.compareTo(this.getMax()) <= 0;
    }

    public COSObject put(COSString name, COSObject value) {
        COSNull result = COSNull.NULL;
        List tempKids = this.getKids();
        if (tempKids != null) {
            CDSNameTreeNode insertNode = null;
            Iterator i = tempKids.iterator();
            while (i.hasNext()) {
                CDSNameTreeNode node;
                insertNode = node = (CDSNameTreeNode)i.next();
                if (node.getMax().compareTo(name) > 0) break;
            }
            if (insertNode == null) {
                insertNode = CDSNameTreeNode.createLeaf();
                this.getKids().add(insertNode);
                COSArray cosKids = this.cosGetDict().get(DK_Kids).asArray();
                cosKids.add(insertNode.cosGetObject());
            }
            insertNode.put(name, value);
            this.updateLimits();
            return result;
        }
        List tempEntries = this.getEntries();
        if (tempEntries != null) {
            int index = 0;
            for (CDSNameTreeEntry entry : tempEntries) {
                int c = entry.getName().compareTo(name);
                if (c == 0) {
                    return entry.setValue(value);
                }
                if (c > 0) break;
                ++index;
            }
            CDSNameTreeEntry entry = new CDSNameTreeEntry(name, value);
            tempEntries.add(index, entry);
            COSArray cosEntries = this.cosGetDict().get(DK_Names).asArray();
            int entryIndex = index * 2;
            cosEntries.add(entryIndex, value);
            cosEntries.add(entryIndex, name);
            this.updateLimits();
            return COSNull.NULL;
        }
        return result;
    }

    public COSObject remove(COSString name) {
        List tempKids = this.getKids();
        if (tempKids != null) {
            for (CDSNameTreeNode node : tempKids) {
                if (node.getMax().compareTo(name) <= 0) continue;
                COSObject result = node.remove(name);
                this.updateLimits();
                return result;
            }
            return COSNull.NULL;
        }
        List tempEntries = this.getEntries();
        if (tempEntries != null) {
            int index = 0;
            Iterator it = tempEntries.iterator();
            while (it.hasNext()) {
                CDSNameTreeEntry entry = (CDSNameTreeEntry)it.next();
                int c = entry.getName().compareTo(name);
                if (c == 0) {
                    it.remove();
                    COSArray cosEntries = this.cosGetDict().get(DK_Names).asArray();
                    int entryIndex = index * 2;
                    cosEntries.remove(entryIndex);
                    cosEntries.remove(entryIndex);
                    COSObject result = entry.getValue();
                    this.updateLimits();
                    return result;
                }
                if (c > 0) break;
                ++index;
            }
            return COSNull.NULL;
        }
        return COSNull.NULL;
    }

    protected void updateLimits() {
        List tempEntries;
        if (this.getLimits() == null) {
            return;
        }
        List tempKids = this.getKids();
        if (tempKids != null && tempKids.size() > 0) {
            CDSNameTreeNode minNode = (CDSNameTreeNode)tempKids.get(0);
            minNode.checkLimits();
            this.getLimits().set(0, minNode.getLimits().get(0).copyOptional());
            CDSNameTreeNode maxNode = (CDSNameTreeNode)tempKids.get(tempKids.size() - 1);
            maxNode.checkLimits();
            this.getLimits().set(1, maxNode.getLimits().get(1).copyOptional());
        }
        if ((tempEntries = this.getEntries()) != null && tempEntries.size() > 0) {
            CDSNameTreeEntry minEntry = (CDSNameTreeEntry)tempEntries.get(0);
            this.getLimits().set(0, minEntry.getName().copyOptional());
            CDSNameTreeEntry maxEntry = (CDSNameTreeEntry)tempEntries.get(tempEntries.size() - 1);
            this.getLimits().set(1, maxEntry.getName().copyOptional());
        }
    }
}

