/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSDeviceAdapter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class CSBasicDevice
extends CSDeviceAdapter {
    public static final float THOUSAND = 1000.0f;
    private boolean clip;
    private boolean clipEvenOdd;
    private GeneralPath currentShape;
    private boolean currentShapeDegenerated;
    private boolean currentShapeEmpty;
    private float currentX;
    private float currentY;
    private float initialX;
    private float initialY;

    protected void basicClip(Shape shape) throws CSException {
    }

    protected void basicDraw(Shape shape) throws CSException {
    }

    protected void basicFill(Shape shape) throws CSException {
    }

    protected void basicFillDegenerated(Shape shape) {
    }

    protected void basicTextShowBegin() {
    }

    protected void basicTextShowEnd() {
    }

    protected void basicTextShowGlyphs(PDGlyphs glyphs, float advance) throws CSException {
        this.textMove(advance, 0.0f);
    }

    protected GeneralPath getCurrentShape() {
        return this.currentShape;
    }

    @Override
    public void open(ICSInterpreter interpreter) {
        super.open(interpreter);
        this.currentShape = new GeneralPath();
        this.currentShapeDegenerated = true;
        this.currentShapeEmpty = true;
    }

    @Override
    public void pathClipEvenOdd() {
        this.clip = true;
        this.clipEvenOdd = true;
    }

    @Override
    public void pathClipNonZero() {
        this.clip = true;
        this.clipEvenOdd = false;
    }

    @Override
    public void pathClose() {
        this.privateClosePath();
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
        this.privateClosePath();
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
        this.privateClosePath();
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathCloseStroke() {
        this.privateClosePath();
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathEnd() {
        this.privateClip();
    }

    @Override
    public void pathFillEvenOdd() {
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        if (this.currentShapeDegenerated) {
            this.basicFillDegenerated(this.currentShape);
        }
        this.privateClip();
    }

    @Override
    public void pathFillNonZero() {
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        if (this.currentShapeDegenerated) {
            this.basicFillDegenerated(this.currentShape);
        }
        this.privateClip();
    }

    @Override
    public void pathFillStrokeEvenOdd() {
        this.currentShape.setWindingRule(0);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathFillStrokeNonZero() {
        this.currentShape.setWindingRule(1);
        this.basicFill(this.currentShape);
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void pathStroke() {
        this.basicDraw(this.currentShape);
        this.privateClip();
    }

    @Override
    public void penCurveToC(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(x1, y1, x2, y2, x3, y3);
        this.currentX = x3;
        this.currentY = y3;
    }

    @Override
    public void penCurveToV(float x2, float y2, float x3, float y3) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(this.currentX, this.currentY, x2, y2, x3, y3);
        this.currentX = x3;
        this.currentY = y3;
    }

    @Override
    public void penCurveToY(float x1, float y1, float x3, float y3) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.curveTo(x1, y1, x3, y3, x3, y3);
        this.currentX = x3;
        this.currentY = y3;
    }

    @Override
    public void penLineTo(float x, float y) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.currentShape.lineTo(x, y);
        this.currentX = x;
        this.currentY = y;
    }

    @Override
    public void penMoveTo(float x, float y) {
        this.clip = false;
        this.clipEvenOdd = false;
        this.currentShape.moveTo(x, y);
        this.initialX = x;
        this.initialY = y;
        this.currentX = x;
        this.currentY = y;
    }

    @Override
    public void penRectangle(float x, float y, float w, float h) {
        if (this.currentShapeEmpty) {
            this.currentShapeEmpty = false;
            this.currentShapeDegenerated = w <= 1.0f && w >= -1.0f || h <= 1.0f && h >= -1.0f;
        } else {
            this.currentShapeDegenerated = false;
        }
        this.clip = false;
        this.clipEvenOdd = false;
        this.currentShape.moveTo(x, y);
        this.currentShape.lineTo(x + w, y);
        this.currentShape.lineTo(x + w, y + h);
        this.currentShape.lineTo(x, y + h);
        this.currentShape.closePath();
        this.initialX = x;
        this.initialY = y;
        this.currentX = x;
        this.currentY = y;
    }

    protected void privateClip() {
        if (this.clip) {
            Shape shape;
            if (this.clipEvenOdd) {
                this.currentShape.setWindingRule(0);
            } else {
                this.currentShape.setWindingRule(1);
            }
            if (this.graphicsState.clip != null) {
                Area newShape = new Area(this.currentShape);
                Area intersection = new Area(this.graphicsState.clip);
                intersection.intersect(newShape);
                shape = intersection;
            } else {
                shape = this.currentShape;
            }
            this.graphicsState.clip = ApplySpaceChangeShape.create((Shape)shape, (AffineTransform)this.graphicsState.transform);
            this.basicClip(this.currentShape);
        }
        this.clip = false;
        this.currentShape = new GeneralPath();
        this.currentShapeDegenerated = true;
        this.currentShapeEmpty = true;
    }

    protected void privateClosePath() {
        this.currentShape.closePath();
        this.currentX = this.initialX;
        this.currentY = this.initialY;
    }

    @Override
    public void textShow(byte[] text, int offset, int length) {
        PDFont font;
        TextState ts = this.textState;
        if (ts.rise != 0.0f) {
            this.textMove(0.0f, ts.rise);
        }
        if ((font = ts.font) == null) {
            return;
        }
        float advanceFactor = ts.derivedGlyphAdvanceFactor;
        float charSpacing = ts.derivedCharSpacingScaled;
        float wordSpacing = ts.derivedWordSpacingScaled;
        ByteArrayInputStream is = new ByteArrayInputStream(text);
        this.basicTextShowBegin();
        while (true) {
            try {
                PDGlyphs glyphs;
                while ((glyphs = font.getNextGlyphsEncoded(is)) != null) {
                    float advance = advanceFactor * glyphs.getWidth() + (wordSpacing != 0.0f && glyphs.isWhitespace() ? wordSpacing : 0.0f) + charSpacing;
                    this.basicTextShowGlyphs(glyphs, advance);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        this.basicTextShowEnd();
    }
}

