/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import java.util.Iterator;
import java.util.Map;

public class CSDeviceBasedInterpreter
extends CSInterpreter {
    private float advanceFactor = 0.0f;
    protected final ICSDevice device;
    private float fontSize = 0.0f;
    private float horizontalScalingFactor = 1.0f;
    private int nesting = 0;
    private boolean supportsColorSpace = true;
    private boolean supportsExtendedState = true;
    private boolean supportsFont = true;
    private boolean supportsInlineImage = true;
    private boolean supportsPattern = true;
    private boolean supportsProperties = true;
    private boolean supportsShading = true;
    private boolean supportsXObject = true;

    public CSDeviceBasedInterpreter(Map paramOptions, ICSDevice device) {
        super(paramOptions);
        this.device = device;
        if (device instanceof ICSDeviceFeatures) {
            this.supportsColorSpace = ((ICSDeviceFeatures)((Object)device)).supportsColorSpace();
            this.supportsExtendedState = ((ICSDeviceFeatures)((Object)device)).supportsExtendedState();
            this.supportsFont = ((ICSDeviceFeatures)((Object)device)).supportsFont();
            this.supportsInlineImage = ((ICSDeviceFeatures)((Object)device)).supportsInlineImage();
            this.supportsPattern = ((ICSDeviceFeatures)((Object)device)).supportsPattern();
            this.supportsProperties = ((ICSDeviceFeatures)((Object)device)).supportsProperties();
            this.supportsShading = ((ICSDeviceFeatures)((Object)device)).supportsShading();
            this.supportsXObject = ((ICSDeviceFeatures)((Object)device)).supportsXObject();
        }
    }

    public ICSDevice getDevice() {
        return this.device;
    }

    protected PDColorSpace lookupColorSpace(COSName name) {
        if (!this.supportsColorSpace) {
            return null;
        }
        PDColorSpace result = PDColorSpace.getNamed(name);
        if (result == null) {
            if (this.getResources() == null) {
                throw new IllegalStateException("resource dictionary missing");
            }
            return this.getResources().getColorSpaceResource(name);
        }
        return result;
    }

    protected PDExtGState lookupExtGState(COSName name) {
        if (!this.supportsExtendedState) {
            return null;
        }
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getExtGStateResource(name);
    }

    protected PDFont lookupFont(COSName fontname) {
        if (!this.supportsFont) {
            return null;
        }
        return PDFontTools.getFont(this.getDoc(), this.getResources(), fontname);
    }

    protected PDPattern lookupPattern(COSName name) {
        if (!this.supportsPattern) {
            return null;
        }
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getPatternResource(name);
    }

    protected COSDictionary lookupProperties(COSName name) {
        if (!this.supportsProperties) {
            return null;
        }
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().cosGetResource(PDResources.CN_RT_Properties, name).asDictionary();
    }

    protected PDShading lookupShading(COSName name) {
        if (!this.supportsShading) {
            return null;
        }
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getShadingResource(name);
    }

    protected PDXObject lookupXObject(COSName name) {
        if (!this.supportsXObject) {
            return null;
        }
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getXObjectResource(name);
    }

    @Override
    public void process(CSContent pContent, PDResources resourceDict) throws CSException {
        try {
            if (this.nesting == 0) {
                this.device.open(this);
            }
            ++this.nesting;
            super.process(pContent, resourceDict);
        }
        finally {
            --this.nesting;
            if (this.nesting == 0) {
                this.device.close();
            }
        }
    }

    @Override
    protected void render_b(CSOperation operation) {
        try {
            this.device.pathCloseFillStrokeNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_B(CSOperation operation) {
        try {
            this.device.pathFillStrokeNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_BDC(CSOperation operation) throws CSException {
        COSName resourceName;
        COSName tag = ((COSName)operation.getOperand(0)).asName();
        COSObject op1 = operation.getOperand(1);
        COSDictionary properties = null;
        if (op1 instanceof COSName) {
            resourceName = (COSName)op1;
            properties = this.lookupProperties(resourceName);
        } else {
            resourceName = null;
            properties = (COSDictionary)op1;
        }
        this.device.markedContentBeginProperties(tag, resourceName, properties);
    }

    @Override
    protected void render_BMC(CSOperation operation) throws CSException {
        COSName tag = ((COSName)operation.getOperand(0)).asName();
        this.device.markedContentBegin(tag);
    }

    @Override
    protected void render_bstar(CSOperation operation) {
        try {
            this.device.pathCloseFillStrokeEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_Bstar(CSOperation operation) {
        try {
            this.device.pathFillStrokeEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_BT(CSOperation operation) {
        this.frame.graphicsObjectState = 1;
        this.device.textBegin();
    }

    @Override
    protected void render_c(CSOperation operation) {
        float x1 = ((COSNumber)operation.getOperand(0)).floatValue();
        float y1 = ((COSNumber)operation.getOperand(1)).floatValue();
        float x2 = ((COSNumber)operation.getOperand(2)).floatValue();
        float y2 = ((COSNumber)operation.getOperand(3)).floatValue();
        float x3 = ((COSNumber)operation.getOperand(4)).floatValue();
        float y3 = ((COSNumber)operation.getOperand(5)).floatValue();
        this.device.penCurveToC(x1, y1, x2, y2, x3, y3);
    }

    @Override
    protected void render_cm(CSOperation operation) {
        if (this.frame.graphicsObjectState != 0 && this.frame.graphicsObjectState != 6 && this.frame.graphicsObjectState != 1) {
            throw new CSWarning("'cm' not allowed");
        }
        float a = ((COSNumber)operation.getOperand(0)).floatValue();
        float b = ((COSNumber)operation.getOperand(1)).floatValue();
        float c = ((COSNumber)operation.getOperand(2)).floatValue();
        float d = ((COSNumber)operation.getOperand(3)).floatValue();
        float e = ((COSNumber)operation.getOperand(4)).floatValue();
        float f = ((COSNumber)operation.getOperand(5)).floatValue();
        this.device.transform(a, b, c, d, e, f);
    }

    @Override
    protected void render_cs(CSOperation operation) {
        COSName name = operation.getOperand(0).asName();
        PDColorSpace colorSpace = this.selectColorSpace(name);
        this.device.setNonStrokeColorSpace(name, colorSpace);
    }

    @Override
    protected void render_CS(CSOperation operation) {
        COSName name = operation.getOperand(0).asName();
        PDColorSpace colorSpace = this.selectColorSpace(name);
        this.device.setStrokeColorSpace(name, colorSpace);
    }

    @Override
    protected void render_d(CSOperation operation) {
        COSArray cosDashArray = (COSArray)operation.getOperand(0);
        float[] pattern = new float[cosDashArray.size()];
        int i = 0;
        Iterator<COSObject> it = cosDashArray.iterator();
        while (it.hasNext()) {
            COSNumber element = it.next().asNumber();
            if (element == null) continue;
            pattern[i] = element.floatValue();
            ++i;
        }
        float phase = ((COSNumber)operation.getOperand(1)).floatValue();
        this.device.setLineDash(pattern, phase);
    }

    @Override
    protected void render_Do(CSOperation operation) throws CSException {
        COSName name = (COSName)operation.getOperand(0);
        PDXObject xobject = this.lookupXObject(name);
        this.device.doXObject(name, xobject);
    }

    @Override
    protected void render_DoubleQuote(CSOperation operation) throws CSException {
        float ws = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.textSetWordSpacing(ws);
        float cs = ((COSNumber)operation.getOperand(1)).floatValue();
        this.device.textSetCharSpacing(cs);
        this.device.textLineNew();
        byte[] value = ((COSString)operation.getOperand(2)).byteValue();
        this.device.textShow(value, 0, value.length);
    }

    @Override
    protected void render_DP(CSOperation operation) throws CSException {
        COSName resourceName;
        COSName tag = ((COSName)operation.getOperand(0)).asName();
        COSObject op1 = operation.getOperand(1);
        COSDictionary properties = null;
        if (op1 instanceof COSName) {
            resourceName = (COSName)op1;
            properties = this.lookupProperties(resourceName);
        } else {
            resourceName = null;
            properties = (COSDictionary)op1;
        }
        this.device.markedContentPointProperties(tag, resourceName, properties);
    }

    @Override
    protected void render_EI(CSOperation operation) throws CSException {
        this.frame.graphicsObjectState = 4;
        try {
            PDImage image = (PDImage)operation.getCache();
            if (image == null && this.supportsInlineImage) {
                PDColorSpace pdCS;
                COSStream cosStream = operation.getOperand(0).asStream();
                image = (PDImage)PDImage.META.createFromCos(cosStream);
                COSObject cs = image.cosGetColorSpace();
                if (cs instanceof COSName && this.getResources() != null && (pdCS = this.getResources().getColorSpaceResource((COSName)cs)) != null) {
                    image.setColorSpace(pdCS);
                }
                operation.setCache(image);
            }
            this.device.inlineImage(image);
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_EMC(CSOperation operation) throws CSException {
        this.device.markedContentEnd();
    }

    @Override
    protected void render_ET(CSOperation operation) {
        try {
            this.device.textEnd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_f(CSOperation operation) {
        try {
            this.device.pathFillNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_F(CSOperation operation) {
        try {
            this.device.pathFillNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_fstar(CSOperation operation) {
        try {
            this.device.pathFillEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_g(CSOperation operation) {
        if (this.frame.defaultGray != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultGray, this.frame.defaultGray);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue()};
            this.device.setNonStrokeColorValues(values);
        } else {
            this.device.setNonStrokeColorGray(((COSNumber)operation.getOperand(0)).floatValue());
        }
    }

    @Override
    protected void render_G(CSOperation operation) {
        if (this.frame.defaultGray != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultGray, this.frame.defaultGray);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue()};
            this.device.setStrokeColorValues(values);
        } else {
            this.device.setStrokeColorGray(((COSNumber)operation.getOperand(0)).floatValue());
        }
    }

    @Override
    protected void render_gs(CSOperation operation) {
        COSName name = operation.getOperand(0).asName();
        PDExtGState gstate = this.lookupExtGState(name);
        this.device.setExtendedState(name, gstate);
    }

    @Override
    protected void render_h(CSOperation operation) {
        this.device.pathClose();
    }

    @Override
    protected void render_i(CSOperation operation) throws CSException {
        float flatness = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.setFlatnessTolerance(flatness);
    }

    @Override
    protected void render_j(CSOperation operation) {
        int joinStyle = ((COSNumber)operation.getOperand(0)).intValue();
        this.device.setLineJoin(joinStyle);
    }

    @Override
    protected void render_J(CSOperation operation) {
        int cap = ((COSNumber)operation.getOperand(0)).intValue();
        this.device.setLineCap(cap);
    }

    @Override
    protected void render_k(CSOperation operation) {
        if (this.frame.defaultCMYK != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultCMYK, this.frame.defaultCMYK);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue(), ((COSNumber)operation.getOperand(3)).floatValue()};
            this.device.setNonStrokeColorValues(values);
        } else {
            this.device.setNonStrokeColorCMYK(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue(), ((COSNumber)operation.getOperand(3)).floatValue());
        }
    }

    @Override
    protected void render_K(CSOperation operation) {
        if (this.frame.defaultCMYK != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultCMYK, this.frame.defaultCMYK);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue(), ((COSNumber)operation.getOperand(3)).floatValue()};
            this.device.setStrokeColorValues(values);
        } else {
            this.device.setStrokeColorCMYK(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue(), ((COSNumber)operation.getOperand(3)).floatValue());
        }
    }

    @Override
    protected void render_l(CSOperation operation) {
        this.device.penLineTo(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue());
    }

    @Override
    protected void render_m(CSOperation operation) {
        this.frame.graphicsObjectState = 6;
        this.device.penMoveTo(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue());
    }

    @Override
    protected void render_M(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.setMiterLimit(value);
    }

    @Override
    protected void render_MP(CSOperation operation) throws CSException {
        COSName tag = ((COSName)operation.getOperand(0)).asName();
        this.device.markedContentPoint(tag);
    }

    @Override
    protected void render_n(CSOperation operation) {
        try {
            this.device.pathEnd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_q(CSOperation operation) throws CSException {
        if (this.frame.graphicsObjectState != 0 && this.frame.graphicsObjectState != 6) {
            throw new CSWarning("'q' not allowed");
        }
        this.device.saveState();
    }

    @Override
    protected void render_Q(CSOperation operation) throws CSException {
        if (this.frame.graphicsObjectState != 0 && this.frame.graphicsObjectState != 6) {
            throw new CSWarning("'Q' not allowed");
        }
        this.device.restoreState();
    }

    @Override
    protected void render_Quote(CSOperation operation) throws CSException {
        this.device.textLineNew();
        byte[] value = ((COSString)operation.getOperand(0)).byteValue();
        this.device.textShow(value, 0, value.length);
    }

    @Override
    protected void render_re(CSOperation operation) {
        float x = ((COSNumber)operation.getOperand(0)).floatValue();
        float y = ((COSNumber)operation.getOperand(1)).floatValue();
        float width = ((COSNumber)operation.getOperand(2)).floatValue();
        float height = ((COSNumber)operation.getOperand(3)).floatValue();
        this.device.penRectangle(x, y, width, height);
    }

    @Override
    protected void render_rg(CSOperation operation) {
        if (this.frame.defaultRGB != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultRGB, this.frame.defaultRGB);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue()};
            this.device.setNonStrokeColorValues(values);
        } else {
            this.device.setNonStrokeColorRGB(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue());
        }
    }

    @Override
    protected void render_RG(CSOperation operation) {
        if (this.frame.defaultRGB != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultRGB, this.frame.defaultRGB);
            float[] values = new float[]{((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue()};
            this.device.setStrokeColorValues(values);
        } else {
            this.device.setStrokeColorRGB(((COSNumber)operation.getOperand(0)).floatValue(), ((COSNumber)operation.getOperand(1)).floatValue(), ((COSNumber)operation.getOperand(2)).floatValue());
        }
    }

    @Override
    protected void render_ri(CSOperation operation) throws CSException {
        COSName intent = ((COSName)operation.getOperand(0)).asName();
        this.device.setRenderingIntent(intent);
    }

    @Override
    protected void render_s(CSOperation operation) {
        try {
            this.device.pathCloseStroke();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_S(CSOperation operation) {
        try {
            this.device.pathStroke();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    @Override
    protected void render_sc(CSOperation operation) {
        int totalSize = operation.operandSize();
        float[] values = new float[totalSize];
        int i = 0;
        while (i < totalSize) {
            values[i] = ((COSNumber)operation.getOperand(i)).floatValue();
            ++i;
        }
        this.device.setNonStrokeColorValues(values);
    }

    @Override
    protected void render_SC(CSOperation operation) {
        int totalSize = operation.operandSize();
        float[] values = new float[totalSize];
        int i = 0;
        while (i < totalSize) {
            values[i] = ((COSNumber)operation.getOperand(i)).floatValue();
            ++i;
        }
        this.device.setStrokeColorValues(values);
    }

    @Override
    protected void render_scn(CSOperation operation) {
        int totalSize;
        int numberSize = totalSize = operation.operandSize();
        COSName patternName = null;
        if (totalSize > 0 && operation.getOperand(totalSize - 1) instanceof COSName) {
            patternName = (COSName)operation.getOperand(totalSize - 1);
            --numberSize;
        }
        float[] values = new float[numberSize];
        int i = 0;
        while (i < numberSize) {
            values[i] = ((COSNumber)operation.getOperand(i)).floatValue();
            ++i;
        }
        if (patternName == null) {
            this.device.setNonStrokeColorValues(values);
        } else {
            PDPattern pattern = this.lookupPattern(patternName);
            this.device.setNonStrokeColorValues(values, patternName, pattern);
        }
    }

    @Override
    protected void render_SCN(CSOperation operation) {
        int totalSize;
        int numberSize = totalSize = operation.operandSize();
        COSName patternName = null;
        if (totalSize > 0 && operation.getOperand(totalSize - 1) instanceof COSName) {
            patternName = (COSName)operation.getOperand(totalSize - 1);
            --numberSize;
        }
        float[] values = new float[numberSize];
        int i = 0;
        while (i < numberSize) {
            values[i] = ((COSNumber)operation.getOperand(i)).floatValue();
            ++i;
        }
        if (patternName == null) {
            this.device.setStrokeColorValues(values);
        } else {
            PDPattern pattern = this.lookupPattern(patternName);
            this.device.setStrokeColorValues(values, patternName, pattern);
        }
    }

    @Override
    protected void render_sh(CSOperation operation) {
        COSName name = operation.getOperand(0).asName();
        PDShading shading = this.lookupShading(name);
        this.device.doShading(name, shading);
    }

    @Override
    protected void render_Tc(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.textSetCharSpacing(value);
    }

    @Override
    protected void render_Td(CSOperation operation) {
        float x = ((COSNumber)operation.getOperand(0)).floatValue();
        float y = ((COSNumber)operation.getOperand(1)).floatValue();
        this.device.textLineMove(x, y);
    }

    @Override
    protected void render_TD(CSOperation operation) {
        float x = ((COSNumber)operation.getOperand(0)).floatValue();
        float y = ((COSNumber)operation.getOperand(1)).floatValue();
        this.device.textSetLeading(y);
        this.device.textLineMove(x, y);
    }

    @Override
    protected void render_Tf(CSOperation operation) throws CSWarning {
        COSName fontname = operation.getOperand(0).asName();
        PDFont pdFont = this.lookupFont(fontname);
        this.fontSize = operation.getOperand(1).asNumber().floatValue();
        this.advanceFactor = -1.0f * this.horizontalScalingFactor * this.fontSize / 1000.0f;
        this.device.textSetFont(fontname, pdFont, this.fontSize);
    }

    @Override
    protected void render_Tj(CSOperation operation) throws CSException {
        byte[] value = ((COSString)operation.getOperand(0)).byteValue();
        this.device.textShow(value, 0, value.length);
    }

    @Override
    protected void render_TJ(CSOperation operation) throws CSException {
        COSDocumentElement[] array = operation.getOperand(0).asArray().toArray();
        int length = array.length;
        int i = 0;
        while (i < length) {
            COSObject cosObj = (COSObject)array[i];
            if (cosObj instanceof COSNumber) {
                float offset = ((COSNumber)cosObj).floatValue();
                this.device.textMove(offset * this.advanceFactor, 0.0f);
            } else if (cosObj instanceof COSString) {
                byte[] value = ((COSString)cosObj).byteValue();
                this.device.textShow(value, 0, value.length);
            }
            ++i;
        }
    }

    @Override
    protected void render_TL(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.textSetLeading(-value);
    }

    @Override
    protected void render_Tm(CSOperation operation) {
        float a = ((COSNumber)operation.getOperand(0)).floatValue();
        float b = ((COSNumber)operation.getOperand(1)).floatValue();
        float c = ((COSNumber)operation.getOperand(2)).floatValue();
        float d = ((COSNumber)operation.getOperand(3)).floatValue();
        float e = ((COSNumber)operation.getOperand(4)).floatValue();
        float f = ((COSNumber)operation.getOperand(5)).floatValue();
        this.device.textSetTransform(a, b, c, d, e, f);
    }

    @Override
    protected void render_Tr(CSOperation operation) {
        int value = ((COSNumber)operation.getOperand(0)).intValue();
        this.device.textSetRenderingMode(value);
    }

    @Override
    protected void render_Ts(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.textSetRise(value);
    }

    @Override
    protected void render_Tstar(CSOperation operation) {
        this.device.textLineNew();
    }

    @Override
    protected void render_Tw(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.device.textSetWordSpacing(value);
    }

    @Override
    protected void render_Tz(CSOperation operation) {
        float value = ((COSNumber)operation.getOperand(0)).floatValue();
        this.horizontalScalingFactor = value / 100.0f;
        this.advanceFactor = -1.0f * this.horizontalScalingFactor * this.fontSize / 1000.0f;
        this.device.textSetHorizontalScaling(value);
    }

    @Override
    protected void render_v(CSOperation operation) {
        float x2 = ((COSNumber)operation.getOperand(0)).floatValue();
        float y2 = ((COSNumber)operation.getOperand(1)).floatValue();
        float x3 = ((COSNumber)operation.getOperand(2)).floatValue();
        float y3 = ((COSNumber)operation.getOperand(3)).floatValue();
        this.device.penCurveToV(x2, y2, x3, y3);
    }

    @Override
    protected void render_w(CSOperation operation) {
        this.device.setLineWidth(((COSNumber)operation.getOperand(0)).floatValue());
    }

    @Override
    protected void render_W(CSOperation operation) {
        this.frame.graphicsObjectState = 5;
        this.device.pathClipNonZero();
    }

    @Override
    protected void render_Wstar(CSOperation operation) {
        this.frame.graphicsObjectState = 5;
        this.device.pathClipEvenOdd();
    }

    @Override
    protected void render_y(CSOperation operation) {
        float x1 = ((COSNumber)operation.getOperand(0)).floatValue();
        float y1 = ((COSNumber)operation.getOperand(1)).floatValue();
        float x2 = ((COSNumber)operation.getOperand(2)).floatValue();
        float y2 = ((COSNumber)operation.getOperand(3)).floatValue();
        this.device.penCurveToY(x1, y1, x2, y2);
    }

    protected PDColorSpace selectColorSpace(COSName name) {
        PDColorSpace result = null;
        if (PDColorSpace.CN_CS_DeviceCMYK.equals(name)) {
            result = this.frame.defaultCMYK;
        } else if (PDColorSpace.CN_CS_DeviceRGB.equals(name)) {
            result = this.frame.defaultRGB;
        } else if (PDColorSpace.CN_CS_DeviceGray.equals(name)) {
            result = this.frame.defaultGray;
        }
        if (result == null) {
            return this.lookupColorSpace(name);
        }
        return result;
    }
}

