/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;

public abstract class CSDeviceFilter
implements ICSDevice,
ICSDeviceFeatures {
    private final ICSDevice device;
    private boolean supportsColorSpace = true;
    private boolean supportsExtendedState = true;
    private boolean supportsFont = true;
    private boolean supportsInlineImage = true;
    private boolean supportsPattern = true;
    private boolean supportsProperties = true;
    private boolean supportsShading = true;
    private boolean supportsXObject = true;

    public CSDeviceFilter(ICSDevice device) {
        this.device = device;
        if (device instanceof ICSDeviceFeatures) {
            this.supportsColorSpace = ((ICSDeviceFeatures)((Object)device)).supportsColorSpace();
            this.supportsExtendedState = ((ICSDeviceFeatures)((Object)device)).supportsExtendedState();
            this.supportsFont = ((ICSDeviceFeatures)((Object)device)).supportsFont();
            this.supportsInlineImage = ((ICSDeviceFeatures)((Object)device)).supportsInlineImage();
            this.supportsPattern = ((ICSDeviceFeatures)((Object)device)).supportsPattern();
            this.supportsProperties = ((ICSDeviceFeatures)((Object)device)).supportsProperties();
            this.supportsShading = ((ICSDeviceFeatures)((Object)device)).supportsShading();
            this.supportsXObject = ((ICSDeviceFeatures)((Object)device)).supportsXObject();
        }
    }

    @Override
    public void close() {
        this.getDevice().close();
    }

    @Override
    public void compatibilityBegin() {
        this.getDevice().compatibilityBegin();
    }

    @Override
    public void compatibilityEnd() {
        this.getDevice().compatibilityEnd();
    }

    protected void doForm(COSName name, PDForm form) throws CSException {
        this.saveState();
        try {
            CDSMatrix m = form.getMatrix();
            if (m != null) {
                this.transform(m.getA(), m.getB(), m.getC(), m.getD(), m.getE(), m.getF());
            }
            CDSRectangle r = form.getBoundingBox();
            if (this.getInterpreter() != null) {
                this.getInterpreter().process(form.getContentStream(), form.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName name, PDImage image) throws CSException {
        this.getDevice().doXObject(name, image);
    }

    protected void doPostScript(COSName name, PDPostScript postscript) throws CSException {
    }

    @Override
    public void doShading(COSName resourceName, PDShading shading) {
        this.getDevice().doShading(resourceName, shading);
    }

    @Override
    public void doXObject(COSName name, PDXObject xobject) {
        if (xobject == null) {
            return;
        }
        if (xobject.isForm()) {
            try {
                this.doForm(name, (PDForm)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering form", e);
            }
        } else if (xobject.isImage()) {
            try {
                this.doImage(name, (PDImage)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering image", e);
            }
        } else if (xobject.isPostscript()) {
            try {
                this.doPostScript(name, (PDPostScript)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering postscript", e);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public ICSDevice getDevice() {
        return this.device;
    }

    @Override
    public GraphicsState getGraphicsState() {
        return this.getDevice().getGraphicsState();
    }

    @Override
    public ICSInterpreter getInterpreter() {
        return this.getDevice().getInterpreter();
    }

    @Override
    public void inlineImage(PDImage img) {
        this.getDevice().inlineImage(img);
    }

    @Override
    public void markedContentBegin(COSName tag) {
        this.getDevice().markedContentBegin(tag);
    }

    @Override
    public void markedContentBeginProperties(COSName tag, COSName resourceName, COSDictionary properties) {
        this.getDevice().markedContentBeginProperties(tag, resourceName, properties);
    }

    @Override
    public void markedContentEnd() {
        this.getDevice().markedContentEnd();
    }

    @Override
    public void markedContentPoint(COSName tag) {
        this.getDevice().markedContentPoint(tag);
    }

    @Override
    public void markedContentPointProperties(COSName tag, COSName resourceName, COSDictionary properties) {
        this.getDevice().markedContentPointProperties(tag, resourceName, properties);
    }

    @Override
    public void open(ICSInterpreter interpreter) {
        this.getDevice().open(interpreter);
    }

    @Override
    public void pathClipEvenOdd() {
        this.getDevice().pathClipEvenOdd();
    }

    @Override
    public void pathClipNonZero() {
        this.getDevice().pathClipNonZero();
    }

    @Override
    public void pathClose() {
        this.getDevice().pathClose();
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
        this.getDevice().pathCloseFillStrokeEvenOdd();
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
        this.getDevice().pathCloseFillStrokeNonZero();
    }

    @Override
    public void pathCloseStroke() {
        this.getDevice().pathCloseStroke();
    }

    @Override
    public void pathEnd() {
        this.getDevice().pathEnd();
    }

    @Override
    public void pathFillEvenOdd() {
        this.getDevice().pathFillEvenOdd();
    }

    @Override
    public void pathFillNonZero() {
        this.getDevice().pathFillNonZero();
    }

    @Override
    public void pathFillStrokeEvenOdd() {
        this.getDevice().pathFillStrokeEvenOdd();
    }

    @Override
    public void pathFillStrokeNonZero() {
        this.getDevice().pathFillStrokeNonZero();
    }

    @Override
    public void pathStroke() {
        this.getDevice().pathStroke();
    }

    @Override
    public void penCurveToC(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.getDevice().penCurveToC(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void penCurveToV(float x2, float y2, float x3, float y3) {
        this.getDevice().penCurveToV(x2, y2, x3, y3);
    }

    @Override
    public void penCurveToY(float x1, float y1, float x3, float y3) {
        this.getDevice().penCurveToY(x1, y1, x3, y3);
    }

    @Override
    public void penLineTo(float x, float y) {
        this.getDevice().penLineTo(x, y);
    }

    @Override
    public void penMoveTo(float x, float y) {
        this.getDevice().penMoveTo(x, y);
    }

    @Override
    public void penRectangle(float x, float y, float w, float h) {
        this.getDevice().penRectangle(x, y, w, h);
    }

    @Override
    public void restoreState() {
        this.getDevice().restoreState();
    }

    @Override
    public void saveState() {
        this.getDevice().saveState();
    }

    @Override
    public void setExtendedState(COSName resourceName, PDExtGState gstate) {
        this.getDevice().setExtendedState(resourceName, gstate);
    }

    @Override
    public void setFlatnessTolerance(float flatness) {
        this.getDevice().setFlatnessTolerance(flatness);
    }

    @Override
    public void setLineCap(int capStyle) {
        this.getDevice().setLineCap(capStyle);
    }

    @Override
    public void setLineDash(float[] pattern, float phase) {
        this.getDevice().setLineDash(pattern, phase);
    }

    @Override
    public void setLineJoin(int joinStyle) {
        this.getDevice().setLineJoin(joinStyle);
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.getDevice().setLineWidth(lineWidth);
    }

    @Override
    public void setMiterLimit(float miterLimit) {
        this.getDevice().setMiterLimit(miterLimit);
    }

    @Override
    public void setNonStrokeColorCMYK(float c, float m, float y, float k) {
        this.getDevice().setNonStrokeColorCMYK(c, m, y, k);
    }

    @Override
    public void setNonStrokeColorGray(float gray) {
        this.getDevice().setNonStrokeColorGray(gray);
    }

    @Override
    public void setNonStrokeColorRGB(float r, float g, float b) {
        this.getDevice().setNonStrokeColorRGB(r, g, b);
    }

    @Override
    public void setNonStrokeColorSpace(COSName resourceName, PDColorSpace colorSpace) {
        this.getDevice().setNonStrokeColorSpace(resourceName, colorSpace);
    }

    @Override
    public void setNonStrokeColorValues(float[] values) {
        this.getDevice().setNonStrokeColorValues(values);
    }

    @Override
    public void setNonStrokeColorValues(float[] values, COSName resourceName, PDPattern pattern) {
        this.getDevice().setNonStrokeColorValues(values, resourceName, pattern);
    }

    @Override
    public void setRenderingIntent(COSName intent) {
        this.getDevice().setRenderingIntent(intent);
    }

    @Override
    public void setStrokeColorCMYK(float c, float m, float y, float k) {
        this.getDevice().setStrokeColorCMYK(c, m, y, k);
    }

    @Override
    public void setStrokeColorGray(float gray) {
        this.getDevice().setStrokeColorGray(gray);
    }

    @Override
    public void setStrokeColorRGB(float r, float g, float b) {
        this.getDevice().setStrokeColorRGB(r, g, b);
    }

    @Override
    public void setStrokeColorSpace(COSName resourceName, PDColorSpace colorSpace) {
        this.getDevice().setStrokeColorSpace(resourceName, colorSpace);
    }

    @Override
    public void setStrokeColorValues(float[] values) {
        this.getDevice().setStrokeColorValues(values);
    }

    @Override
    public void setStrokeColorValues(float[] values, COSName resourceName, PDPattern pattern) {
        this.getDevice().setStrokeColorValues(values, resourceName, pattern);
    }

    @Override
    public boolean supportsColorSpace() {
        return this.supportsColorSpace;
    }

    @Override
    public boolean supportsExtendedState() {
        return this.supportsExtendedState;
    }

    @Override
    public boolean supportsFont() {
        return this.supportsFont;
    }

    @Override
    public boolean supportsInlineImage() {
        return this.supportsInlineImage;
    }

    @Override
    public boolean supportsPattern() {
        return this.supportsPattern;
    }

    @Override
    public boolean supportsProperties() {
        return this.supportsProperties;
    }

    @Override
    public boolean supportsShading() {
        return this.supportsShading;
    }

    @Override
    public boolean supportsXObject() {
        return this.supportsXObject;
    }

    @Override
    public void textBegin() {
        this.getDevice().textBegin();
    }

    @Override
    public void textEnd() {
        this.getDevice().textEnd();
    }

    @Override
    public void textLineMove(float dx, float dy) {
        this.getDevice().textLineMove(dx, dy);
    }

    @Override
    public void textLineNew() {
        this.getDevice().textLineNew();
    }

    @Override
    public void textMove(float dx, float dy) {
        this.getDevice().textMove(dx, dy);
    }

    @Override
    public void textMoveTo(float x, float y) {
        this.getDevice().textMoveTo(x, y);
    }

    @Override
    public void textSetCharSpacing(float charSpacing) {
        this.getDevice().textSetCharSpacing(charSpacing);
    }

    @Override
    public void textSetFont(COSName resourceName, PDFont font, float size) {
        this.getDevice().textSetFont(resourceName, font, size);
    }

    @Override
    public void textSetHorizontalScaling(float scale) {
        this.getDevice().textSetHorizontalScaling(scale);
    }

    @Override
    public void textSetLeading(float leading) {
        this.getDevice().textSetLeading(leading);
    }

    @Override
    public void textSetRenderingMode(int renderingMode) {
        this.getDevice().textSetRenderingMode(renderingMode);
    }

    @Override
    public void textSetRise(float rise) {
        this.getDevice().textSetRise(rise);
    }

    @Override
    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        this.getDevice().textSetTransform(a, b, c, d, e, f);
    }

    @Override
    public void textSetWordSpacing(float wordSpacing) {
        this.getDevice().textSetWordSpacing(wordSpacing);
    }

    @Override
    public void textShow(byte[] text, int offset, int length) {
        this.getDevice().textShow(text, offset, length);
    }

    @Override
    public void textShow(char[] chars, int offset, int length) {
        this.getDevice().textShow(chars, offset, length);
    }

    @Override
    public void textShow(String text) {
        this.getDevice().textShow(text);
    }

    @Override
    public void textT3SetGlyphWidth(float x, float y) {
        this.getDevice().textT3SetGlyphWidth(x, y);
    }

    @Override
    public void textT3SetGlyphWidthBB(float x, float y, float llx, float lly, float urx, float ury) {
        this.getDevice().textT3SetGlyphWidthBB(x, y, llx, lly, urx, ury);
    }

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        this.getDevice().transform(a, b, c, d, e, f);
    }
}

