/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.text.CSCharacterParser;
import de.intarsys.pdf.content.text.CSTextSearchCandidate;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSTextSearcher
extends CSCharacterParser {
    public static int FLOATING_CONTEXT_LENGTH = 28;
    private String basicSearchString;
    private ArrayList candidates = new ArrayList();
    private char[] floatingContext = new char[FLOATING_CONTEXT_LENGTH];
    private int floatingContextCurrent = 0;
    private ArrayList hits = new ArrayList();
    private boolean ignoreCase = true;
    private double maxDX = 5.0;
    private double maxDY = 5.0;
    private CSTextSearchCandidate nextCandidate;
    private ArrayList qualified = new ArrayList();
    private String searchString;

    protected String basicGetSearchString() {
        return this.basicSearchString;
    }

    protected void check(char foundChar, Rectangle2D charRect) {
        CSTextSearchCandidate candidate;
        Iterator it = this.qualified.iterator();
        while (it.hasNext()) {
            candidate = (CSTextSearchCandidate)it.next();
            if (candidate.acceptSuffix(foundChar)) continue;
            this.hits.add(candidate.getHit());
            it.remove();
        }
        it = this.candidates.iterator();
        while (it.hasNext()) {
            candidate = (CSTextSearchCandidate)it.next();
            if (!candidate.accept(foundChar, charRect)) {
                it.remove();
                continue;
            }
            if (!candidate.isComplete()) continue;
            this.qualified.add(candidate);
            it.remove();
        }
        if (this.nextCandidate == null) {
            this.nextCandidate = new CSTextSearchCandidate(this);
        }
        if (this.nextCandidate.accept(foundChar, charRect)) {
            this.nextCandidate.setPrefix(this.getFloatingContextString());
            if (this.nextCandidate.isComplete()) {
                this.qualified.add(this.nextCandidate);
            } else {
                this.candidates.add(this.nextCandidate);
            }
            this.nextCandidate = null;
        }
        if (foundChar != '\u0000') {
            this.floatingContext[this.floatingContextCurrent++] = foundChar;
            if (this.floatingContextCurrent == this.floatingContext.length) {
                this.floatingContextCurrent = 0;
            }
        }
    }

    protected String getFloatingContextString() {
        String a = new String(this.floatingContext, this.floatingContextCurrent, this.floatingContext.length - this.floatingContextCurrent);
        String b = new String(this.floatingContext, 0, this.floatingContextCurrent);
        return String.valueOf(a) + b;
    }

    public List getHits() {
        Iterator it = this.qualified.iterator();
        while (it.hasNext()) {
            CSTextSearchCandidate candidate = (CSTextSearchCandidate)it.next();
            candidate.flush();
            this.hits.add(candidate.getHit());
            it.remove();
        }
        return this.hits;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    protected void onCharacterFound(PDGlyphs glyphs, Rectangle2D rect) {
        Rectangle2D.Float spaceRect;
        char[] chars = glyphs.getChars();
        if (chars == null) {
            chars = new char[]{' '};
        }
        double dX = this.lastStopX - this.lastStartX;
        double dY = this.lastStopY - this.lastStartY;
        if (Math.abs(dX) < this.maxDX) {
            if (Math.abs(dY) >= this.maxDY) {
                spaceRect = new Rectangle2D.Float((int)this.lastStartX, (int)this.lastStartY, 0.0f, 0.0f);
                this.check(' ', spaceRect);
            }
        } else {
            spaceRect = new Rectangle2D.Float((int)this.lastStartX, (int)this.lastStartY, 0.0f, 0.0f);
            this.check(' ', spaceRect);
        }
        int i = 0;
        while (i < chars.length) {
            this.check(chars[i], rect);
            ++i;
        }
    }

    @Override
    public void open(ICSInterpreter pInterpreter) {
        super.open(pInterpreter);
        this.candidates.clear();
        this.hits.clear();
        this.nextCandidate = null;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.basicSearchString = this.isIgnoreCase() && this.searchString != null ? this.searchString.toLowerCase() : this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        this.basicSearchString = this.isIgnoreCase() ? searchString.toLowerCase() : searchString;
    }

    @Override
    public void textSetFont(COSName name, PDFont font, float size) {
        super.textSetFont(name, font, size);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }

    @Override
    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        super.textSetTransform(a, b, c, d, e, f);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }
}

