/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class COSArray
extends COSCompositeObject {
    private final List objects;

    public static COSArray create() {
        return new COSArray();
    }

    public static COSArray create(int size) {
        return new COSArray(size);
    }

    public static COSArray createWith(float a, float b, float c, float d) {
        COSArray result = new COSArray(4);
        result.basicAddSilent(COSFixed.create(a));
        result.basicAddSilent(COSFixed.create(b));
        result.basicAddSilent(COSFixed.create(c));
        result.basicAddSilent(COSFixed.create(d));
        return result;
    }

    public static COSArray createWith(float a, float b, float c, float d, float e, float f) {
        COSArray result = new COSArray(6);
        result.basicAddSilent(COSFixed.create(a));
        result.basicAddSilent(COSFixed.create(b));
        result.basicAddSilent(COSFixed.create(c));
        result.basicAddSilent(COSFixed.create(d));
        result.basicAddSilent(COSFixed.create(e));
        result.basicAddSilent(COSFixed.create(f));
        return result;
    }

    protected COSArray() {
        this.objects = new ArrayList();
    }

    protected COSArray(int size) {
        this.objects = new ArrayList(size);
    }

    protected COSArray(List objects) {
        this.objects = objects;
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromArray(this);
    }

    public COSArray add(COSObject object) {
        this.willChange(this);
        this.basicAddPropagate(object);
        if (this.objectListeners != null) {
            this.triggerChanged(this.objects.size(), COSNull.NULL, object);
        }
        return this;
    }

    public COSArray add(int index, COSObject object) {
        this.willChange(this);
        this.basicAddPropagate(index, object);
        if (this.objectListeners != null) {
            this.triggerChanged(index, COSNull.NULL, object);
        }
        return this;
    }

    @Override
    public COSArray asArray() {
        return this;
    }

    protected COSArray basicAddPropagate(COSDocumentElement element) {
        COSObject dereferenced = element.dereference();
        COSDocumentElement containable = element.containable();
        this.willChange(dereferenced);
        ICOSContainer newContainer = containable.addContainer(this);
        this.objects.add(containable);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        return this;
    }

    protected COSArray basicAddPropagate(int index, COSDocumentElement element) {
        COSObject dereferenced = element.dereference();
        COSDocumentElement containable = element.containable();
        this.willChange(dereferenced);
        ICOSContainer newContainer = containable.addContainer(this);
        this.objects.add(index, containable);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        return this;
    }

    public COSArray basicAddSilent(COSDocumentElement element) {
        COSDocumentElement containable = element.containable();
        containable.addContainer(this);
        this.objects.add(containable);
        return this;
    }

    protected void basicClearPropagate() {
        ArrayList oldObjects = new ArrayList(this.objects);
        this.objects.clear();
        for (COSDocumentElement element : oldObjects) {
            COSObject dereferenced = element.dereference();
            this.willChange(dereferenced);
            ICOSContainer newContainer = element.removeContainer(this);
            dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        }
    }

    public COSDocumentElement basicGet(int index) {
        return (COSDocumentElement)this.objects.get(index);
    }

    protected int basicIndexOf(COSDocumentElement element) {
        COSDocumentElement containable = element.containable();
        int i = 0;
        Iterator<COSDocumentElement> it = this.basicIterator();
        while (it.hasNext()) {
            COSDocumentElement current = it.next();
            if (containable == current) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator<COSDocumentElement> basicIterator() {
        return this.objects.iterator();
    }

    protected boolean basicRemovePropagate(COSDocumentElement otherElement) {
        COSObject dereferenced = otherElement.dereference();
        COSDocumentElement containable = otherElement.containable();
        Iterator<COSDocumentElement> i = this.basicIterator();
        while (i.hasNext()) {
            COSDocumentElement element = i.next();
            if (containable != element) continue;
            i.remove();
            this.willChange(dereferenced);
            ICOSContainer newContainer = containable.removeContainer(this);
            dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
            return true;
        }
        return false;
    }

    protected COSDocumentElement basicRemovePropagate(int index) {
        COSDocumentElement removed = (COSDocumentElement)this.objects.remove(index);
        COSObject dereferenced = removed.dereference();
        this.willChange(dereferenced);
        ICOSContainer newContainer = removed.removeContainer(this);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        return removed;
    }

    protected COSDocumentElement basicSetPropagate(int i, COSDocumentElement element) {
        COSObject dereferenced = element.dereference();
        COSDocumentElement containable = element.containable();
        this.willChange(dereferenced);
        ICOSContainer newContainer = containable.addContainer(this);
        COSDocumentElement oldContainable = this.objects.set(i, containable);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        if (oldContainable != containable) {
            COSObject oldDereferenced = oldContainable.dereference();
            this.willChange(oldDereferenced);
            newContainer = oldContainable.removeContainer(this);
            oldDereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        }
        return oldContainable;
    }

    @Override
    protected String basicToString() {
        return this.objects.toString();
    }

    public void clear() {
        this.willChange(this);
        this.basicClearPropagate();
        if (this.objectListeners != null) {
            this.triggerChanged(-1, null, null);
        }
    }

    @Override
    protected COSObject copyBasic() {
        return COSArray.create(this.size());
    }

    @Override
    public COSObject copyDeep(Map copied) {
        COSArray result = (COSArray)super.copyDeep(copied);
        Iterator<COSDocumentElement> i = this.basicIterator();
        while (i.hasNext()) {
            COSDocumentElement element = i.next();
            COSObject copy = element.copyDeep(copied);
            result.basicAddSilent(copy);
        }
        return result;
    }

    @Override
    public COSObject copyShallow() {
        COSArray result = (COSArray)super.copyShallow();
        Iterator<COSDocumentElement> i = this.basicIterator();
        while (i.hasNext()) {
            COSDocumentElement element = i.next();
            result.basicAddSilent(element.copyShallowNested());
        }
        return result;
    }

    @Override
    protected COSObject copySubGraph(Map copied) {
        COSArray result = (COSArray)super.copySubGraph(copied);
        return result;
    }

    @Override
    protected boolean equals(Object o, COSDocumentElement.PairRegister visited) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSArray other = (COSArray)o;
        if (visited.check(this, other)) {
            return true;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<COSDocumentElement> iThis = this.basicIterator();
        Iterator<COSDocumentElement> iOther = other.basicIterator();
        while (iThis.hasNext()) {
            COSObject oOther;
            COSObject oThis = iThis.next().dereference();
            if (oThis.equals(oOther = iOther.next().dereference(), visited)) continue;
            return false;
        }
        return true;
    }

    public COSObject get(int index) {
        try {
            return ((COSDocumentElement)this.objects.get(index)).dereference();
        }
        catch (IndexOutOfBoundsException e) {
            return COSNull.NULL;
        }
    }

    public List getObjects() {
        int size = this.size();
        ArrayList<COSObject> result = new ArrayList<COSObject>(size);
        int i = 0;
        while (i < size) {
            result.add(this.get(i));
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        Iterator<COSDocumentElement> iThis = this.basicIterator();
        while (iThis.hasNext()) {
            COSDocumentElement oThis = iThis.next();
            result = oThis.isReference() ? (result + oThis.hashCode()) * 34 : (((COSObject)oThis).isPrimitive() ? (result + oThis.hashCode()) * 34 : (result + 17) * 34);
        }
        return result;
    }

    public int indexOf(COSObject object) {
        return this.basicIndexOf(object);
    }

    public boolean isEmpty() {
        return this.objects.size() == 0;
    }

    @Override
    public Iterator<COSObject> iterator() {
        return new Iterator<COSObject>(){
            private int index = 0;
            private int size;
            {
                this.size = COSArray.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public COSObject next() {
                return COSArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject object) {
        COSIndirectObject ref = super.referenceIndirect(object);
        int index = this.getObjects().indexOf(object);
        if (index >= 0) {
            this.objects.set(index, ref);
        }
        return ref;
    }

    public boolean remove(COSObject object) {
        this.willChange(this);
        boolean result = this.basicRemovePropagate(object);
        if (this.objectListeners != null && result) {
            this.triggerChanged(-1, object, COSNull.NULL);
        }
        return result;
    }

    public COSObject remove(int index) {
        this.willChange(this);
        COSDocumentElement element = this.basicRemovePropagate(index);
        COSObject object = element.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(index, object, COSNull.NULL);
        }
        return object;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        this.objects.clear();
        this.objects.addAll(((COSArray)object).objects);
        if (this.objectListeners != null) {
            this.triggerChanged(-1, null, null);
        }
    }

    public Object saveState() {
        COSArray result = new COSArray(new ArrayList(this.objects));
        result.container = this.container.saveStateContainer();
        return result;
    }

    public COSObject set(int i, COSObject object) {
        this.willChange(this);
        COSDocumentElement element = this.basicSetPropagate(i, object);
        COSObject oldObject = element.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(i, oldObject, object);
        }
        return oldObject;
    }

    public int size() {
        return this.objects.size();
    }

    public COSDocumentElement[] toArray() {
        return this.objects.toArray(new COSDocumentElement[this.objects.size()]);
    }

    protected void triggerChanged(int slot, COSObject oldValue, COSObject newValue) {
        if (this.objectListeners == null) {
            return;
        }
        Integer slotObject = new Integer(slot);
        for (ICOSObjectListener listener : this.objectListeners) {
            listener.changed(this, slotObject, oldValue, newValue);
        }
    }
}

