/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class COSConverter {
    protected static Object basicToJava(COSObject object, Map visited) {
        if (object instanceof COSArray) {
            ArrayList<Object> result = new ArrayList<Object>();
            Iterator<COSObject> it = ((COSArray)object).iterator();
            while (it.hasNext()) {
                result.add(COSConverter.toJava(it.next(), visited));
            }
            return result;
        }
        if (object instanceof COSDictionary) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Iterator it = ((COSDictionary)object).entryIterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                result.put(((COSName)entry.getKey()).stringValue(), COSConverter.toJava((COSObject)entry.getValue(), visited));
            }
            return result;
        }
        if (object instanceof COSObjectProxy) {
            return COSConverter.toJava(((COSObjectProxy)object).cosGetObject());
        }
        if (object instanceof COSStream) {
            return ((COSStream)object).getDecodedBytes();
        }
        if (object instanceof COSBoolean) {
            return ((COSBoolean)object).booleanValue();
        }
        if (object instanceof COSName) {
            return ((COSName)object).byteValue();
        }
        if (object instanceof COSNull) {
            return null;
        }
        if (object instanceof COSFixed) {
            return Float.valueOf(((COSFixed)object).floatValue());
        }
        if (object instanceof COSInteger) {
            return ((COSInteger)object).intValue();
        }
        if (object instanceof COSString) {
            return ((COSString)object).stringValue();
        }
        throw new IllegalStateException("can not happen");
    }

    public static COSObject toCos(Object javaObject) {
        COSObject result = null;
        if (javaObject instanceof String) {
            result = COSString.create((String)javaObject);
        } else if (javaObject instanceof Integer) {
            result = COSInteger.create((Integer)javaObject);
        } else if (javaObject instanceof Float) {
            result = COSFixed.create(((Float)javaObject).floatValue());
        } else if (javaObject instanceof Double) {
            result = COSFixed.create(((Double)javaObject).floatValue());
        } else if (javaObject instanceof Boolean) {
            result = COSBoolean.create((Boolean)javaObject);
        } else if (javaObject == null) {
            result = COSNull.create();
        } else if (javaObject instanceof Map) {
            result = COSDictionary.create(((Map)javaObject).size());
            for (Map.Entry entry : ((Map)javaObject).entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                ((COSDictionary)result).put(COSName.create(key), COSConverter.toCos(value));
            }
        } else if (javaObject instanceof List) {
            result = COSArray.create(((List)javaObject).size());
            for (Object value : (List)javaObject) {
                ((COSArray)result).add(COSConverter.toCos(value));
            }
        } else if (javaObject instanceof byte[]) {
            result = COSName.create((byte[])javaObject);
        } else if (javaObject instanceof char[]) {
            result = COSString.create(new String((char[])javaObject));
        } else if (javaObject instanceof float[]) {
            float[] floats = (float[])javaObject;
            result = COSArray.create(floats.length);
            int i = 0;
            while (i < floats.length) {
                ((COSArray)result).add(COSFixed.create(floats[i]));
                ++i;
            }
        } else if (javaObject instanceof double[]) {
            double[] doubles = (double[])javaObject;
            result = COSArray.create(doubles.length);
            int i = 0;
            while (i < doubles.length) {
                ((COSArray)result).add(COSFixed.create(doubles[i]));
                ++i;
            }
        } else if (javaObject instanceof int[]) {
            int[] ints = (int[])javaObject;
            result = COSArray.create(ints.length);
            int i = 0;
            while (i < ints.length) {
                ((COSArray)result).add(COSInteger.create(ints[i]));
                ++i;
            }
        } else if (javaObject instanceof Byte) {
            result = COSInteger.create(((Byte)javaObject).intValue());
        } else if (javaObject instanceof Short) {
            result = COSInteger.create(((Short)javaObject).intValue());
        } else if (javaObject instanceof Long) {
            result = COSInteger.create(((Long)javaObject).intValue());
        } else if (javaObject instanceof InputStream) {
            byte[] bytes;
            result = COSStream.create(null);
            try {
                bytes = StreamTools.toByteArray((InputStream)((InputStream)javaObject));
            }
            catch (IOException e) {
                bytes = new byte[]{};
            }
            ((COSStream)result).setDecodedBytes(bytes);
        } else if (javaObject instanceof COSObject) {
            result = (COSObject)javaObject;
        } else {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(javaObject)) + " can not be marshalled to a cos object");
        }
        return result;
    }

    public static Object toJava(COSObject object) {
        return COSConverter.toJava(object, new HashMap());
    }

    public static Object toJava(COSObject object, Map visited) {
        Object result = visited.get(object);
        if (result != null) {
            return result;
        }
        result = COSConverter.basicToJava(object, visited);
        visited.put(object, result);
        return result;
    }

    private COSConverter() {
    }
}

