/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.cos.ICOSExceptionHandler;
import de.intarsys.pdf.cos.ICOSMonitor;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class COSDocument
implements ICOSContainer,
ICOSExceptionHandler,
IAttributeSupport,
ILocatorSupport {
    public static final Object SLOT_ALL = new Attribute("_all_");
    public static final Object SLOT_DIRTY = new Attribute("dirty");
    public static final Object SLOT_LOCATOR = new Attribute("locator");
    public static final Object SLOT_TRAILER = new Attribute("trailer");
    private List<ICOSDocumentListener> documentListeners;
    private ICOSExceptionHandler exceptionHandler;
    private INotificationListener listenSTChange = new INotificationListener(){

        public void handleEvent(Event event) {
            COSDocument.this.onStDocumentChange((AttributeChangedEvent)event);
        }
    };
    private List<ICOSMonitor> monitors;
    private STDocument stDoc;

    public static COSDocument createFromLocator(ILocator locator) throws IOException, COSLoadException {
        return COSDocument.createFromLocator(locator, null);
    }

    public static COSDocument createFromLocator(ILocator locator, Map options) throws IOException, COSLoadException {
        STDocument stDoc = STDocument.createFromLocator(locator, options);
        try {
            return COSDocument.createFromST(stDoc);
        }
        catch (COSLoadException e) {
            if (stDoc != null) {
                try {
                    stDoc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static COSDocument createFromST(STDocument doc) throws COSLoadException {
        COSDocument result = new COSDocument(doc);
        result.initializeFromST();
        result.checkConsistency();
        return result;
    }

    public static COSDocument createNew() {
        return COSDocument.createNew(STDocument.DOCTYPE_PDF);
    }

    public static COSDocument createNew(STDocType docType) {
        STDocument stDoc = STDocument.createNew(docType);
        COSDocument doc = new COSDocument(stDoc);
        doc.initializeFromScratch();
        return doc;
    }

    protected COSDocument() {
        this(STDocument.createNew());
    }

    protected COSDocument(STDocument pStDoc) {
        this.stDoc = pStDoc;
        this.stDoc.setDoc(this);
        this.stDoc.addNotificationListener(AttributeChangedEvent.ID, this.listenSTChange);
    }

    public void add(COSDocumentElement element) {
        COSDocumentElement containable = element.containable();
        containable.addContainer(this);
    }

    public void addDocumentListener(ICOSDocumentListener listener) {
        ArrayList<ICOSDocumentListener> newListeners = this.documentListeners == null ? new ArrayList<ICOSDocumentListener>() : new ArrayList<ICOSDocumentListener>(this.documentListeners);
        newListeners.add(listener);
        this.documentListeners = newListeners;
    }

    public void addMonitor(ICOSMonitor listener) {
        ArrayList<ICOSMonitor> newMonitors = this.monitors == null ? new ArrayList<ICOSMonitor>() : new ArrayList<ICOSMonitor>(this.monitors);
        newMonitors.add(listener);
        this.monitors = newMonitors;
    }

    @Override
    public ICOSContainer associate(ICOSContainer newContainer, COSObject object) {
        if (newContainer == this) {
            return this;
        }
        throw new IllegalStateException("object may only be contained once (use indirect object)");
    }

    protected void checkConsistency() throws COSLoadError {
        if (this.getCatalog() == null) {
            throw new COSLoadError("Catalog missing");
        }
    }

    public void close() throws IOException {
        this.stDoc.close();
    }

    @Override
    public COSDocumentElement containable(COSObject object) {
        return object;
    }

    public COSDocument copyDeep() {
        try {
            return COSDocument.createFromST(this.stGetDoc().copyDeep());
        }
        catch (COSLoadException e) {
            throw new COSRuntimeException(e);
        }
    }

    @Override
    public ICOSContainer disassociate(ICOSContainer oldContainer, COSObject object) {
        if (oldContainer == this) {
            object.basicSetContainer(COSObject.NULL_CONTAINER);
            return COSObject.NULL_CONTAINER;
        }
        throw new IllegalStateException("association inconsistent");
    }

    public IAccessPermissions getAccessPermissions() {
        return this.stGetDoc().getAccessPermissions();
    }

    public synchronized Object getAttribute(Object key) {
        return this.stDoc.getAttribute(key);
    }

    public COSCatalog getCatalog() {
        return this.getTrailer().getRoot();
    }

    @Override
    public COSDocument getDoc() {
        return this;
    }

    public ICOSExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public int getIncrementalCount() {
        return this.stGetDoc().getIncrementalCount();
    }

    public COSInfoDict getInfoDict() {
        return this.getTrailer().getInfoDict();
    }

    public ILocator getLocator() {
        return this.stDoc.getLocator();
    }

    public String getName() {
        return this.stDoc.getName();
    }

    public COSTrailer getTrailer() {
        return this.stGetDoc().getTrailer();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.stDoc.getWriteModeHint();
    }

    @Override
    public void handleException(COSRuntimeException ex) throws COSRuntimeException {
        if (this.exceptionHandler == null) {
            throw ex;
        }
        this.exceptionHandler.handleException(ex);
    }

    @Override
    public void harden(COSObject object) {
    }

    protected void initializeFromScratch() {
    }

    protected void initializeFromST() {
    }

    public boolean isAutoUpdate() {
        return this.stDoc.isAutoUpdate();
    }

    public boolean isDirty() {
        return this.stGetDoc().isDirty();
    }

    public boolean isEncrypted() {
        return this.stGetDoc().isEncrypted();
    }

    public boolean isNew() {
        return this.stDoc.isNew();
    }

    public boolean isReadOnly() {
        return this.stDoc.isReadOnly();
    }

    public Iterator<COSObject> objects() {
        Iterator iteratorObjects = new Iterator(){
            private Iterator indirectObjects;
            COSIndirectObject io;
            {
                this.indirectObjects = COSDocument.this.stGetDoc().objects();
                this.io = null;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.io == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    current = (COSIndirectObject)this.indirectObjects.next();
                    if (current.dereference().isDangling()) continue;
                    this.io = current;
                    break;
lbl7:
                    // 2 sources

                    ** while (this.indirectObjects.hasNext())
                }
lbl8:
                // 2 sources

                return this.io != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                COSIndirectObject result = this.io;
                this.io = null;
                return result.dereference();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iteratorObjects;
    }

    protected void onStDocumentChange(AttributeChangedEvent event) {
        if ("xRefSection".equals(event.getAttribute())) {
            STXRefSection oldXRef = (STXRefSection)event.getOldValue();
            STXRefSection newXRef = (STXRefSection)event.getNewValue();
            COSDictionary oldTrailer = oldXRef == null ? null : oldXRef.cosGetDict();
            COSDictionary newTrailer = newXRef == null ? null : newXRef.cosGetDict();
            this.triggerChanged(SLOT_TRAILER, oldTrailer, newTrailer);
        }
    }

    @Override
    public int referenceCount() {
        return 1;
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject object) {
        throw new IllegalStateException("document can not have indirect references");
    }

    @Override
    public void register(COSDocumentElement object) {
        object.registerWith(this);
    }

    public synchronized Object removeAttribute(Object key) {
        return this.stDoc.removeAttribute(key);
    }

    public void removeDocumentListener(ICOSDocumentListener listener) {
        if (this.documentListeners == null) {
            return;
        }
        ArrayList<ICOSDocumentListener> newListeners = new ArrayList<ICOSDocumentListener>(this.documentListeners);
        newListeners.remove(listener);
        this.documentListeners = newListeners;
    }

    public void removeMonitor(ICOSMonitor monitor) {
        if (this.monitors == null) {
            return;
        }
        ArrayList<ICOSMonitor> newMonitors = new ArrayList<ICOSMonitor>(this.monitors);
        newMonitors.remove(monitor);
        this.monitors = newMonitors;
    }

    public void restore(ILocator locator) throws IOException, COSLoadException {
        this.stDoc.restore(locator);
    }

    @Override
    public ICOSContainer restoreStateContainer(ICOSContainer container) {
        return container;
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator locator) throws IOException {
        this.save(locator, null);
    }

    public void save(ILocator locator, Map options) throws IOException {
        ILocator oldValue = this.getLocator();
        this.stDoc.save(locator, options);
        this.triggerChangedLocator(oldValue, locator);
    }

    @Override
    public ICOSContainer saveStateContainer() {
        return this;
    }

    public synchronized Object setAttribute(Object key, Object value) {
        return this.stDoc.setAttribute(key, value);
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.stDoc.setAutoUpdate(autoUpdate);
    }

    public void setCatalog(COSCatalog catalog) {
        this.getTrailer().setRoot(catalog);
    }

    protected void setDirty(boolean b) {
        boolean oldValue = this.stGetDoc().isDirty();
        this.stGetDoc().setDirty(b);
        if (oldValue != b) {
            this.triggerChangedDirty();
        }
    }

    public void setExceptionHandler(ICOSExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setInfoDict(COSInfoDict infoDict) {
        this.getTrailer().setInfoDict(infoDict);
    }

    public void setName(String name) {
        this.stDoc.setName(name);
        this.triggerChangedLocator(this.getLocator(), this.getLocator());
    }

    public void setWriteModeHint(EnumWriteMode writeMode) {
        this.stDoc.setWriteModeHint(writeMode);
    }

    @Override
    public void soften(COSObject object) {
    }

    public STDocument stGetDoc() {
        return this.stDoc;
    }

    protected void triggerChanged(Object slot, Object oldValue, Object newValue) {
        if (this.documentListeners == null) {
            return;
        }
        for (ICOSDocumentListener listener : this.documentListeners) {
            listener.changed(this, slot, oldValue, newValue);
        }
    }

    public void triggerChangedAll() {
        this.triggerChanged(SLOT_ALL, null, null);
    }

    protected void triggerChangedDirty() {
        Boolean newValue = this.isDirty();
        Boolean oldValue = !this.isDirty();
        this.triggerChanged(SLOT_DIRTY, oldValue, newValue);
    }

    protected void triggerChangedLocator(Object oldValue, Object newValue) {
        this.triggerChanged(SLOT_LOCATOR, oldValue, newValue);
    }

    @Override
    public void willChange(COSObject change) {
        this.setDirty(true);
        if (this.monitors == null) {
            return;
        }
        for (ICOSMonitor monitor : this.monitors) {
            monitor.willChange(change);
        }
    }
}

