/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;

public class COSFixed
extends COSNumber {
    public static final int DEFAULT_PRECISION = 5;
    private final float floatValue;
    private byte precision;

    public static COSFixed create(byte[] bytes, int start, int length) {
        long result = 0L;
        long decimal = 1L;
        int end = start + length;
        boolean negative = false;
        boolean point = false;
        int precision = 0;
        int i = start;
        byte prefix = bytes[i];
        if (prefix == 43) {
            ++i;
        } else if (prefix == 45) {
            negative = true;
            ++i;
        }
        while (i < end) {
            byte digit = bytes[i];
            if (digit == 46) {
                point = true;
            } else {
                result = result * 10L + (long)digit - 48L;
                if (point) {
                    decimal *= 10L;
                    ++precision;
                }
            }
            ++i;
        }
        if (negative) {
            return new COSFixed(-((float)((double)result / (double)decimal)), precision);
        }
        return new COSFixed((float)((double)result / (double)decimal), precision);
    }

    public static COSFixed create(double value) {
        return new COSFixed((float)value, 5);
    }

    public static COSFixed create(double value, int precision) {
        return new COSFixed((float)value, precision);
    }

    public static COSFixed create(float value) {
        return new COSFixed(value, 5);
    }

    public static COSFixed create(float value, int precision) {
        return new COSFixed(value, precision);
    }

    protected COSFixed(float value, int precision) {
        this.floatValue = value;
        this.precision = (byte)precision;
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromFixed(this);
    }

    @Override
    public COSFixed asFixed() {
        return this;
    }

    @Override
    protected String basicToString() {
        return String.valueOf(this.floatValue);
    }

    @Override
    protected COSObject copyBasic() {
        return new COSFixed(this.floatValue, this.precision);
    }

    public boolean equals(Object o) {
        if (!(o instanceof COSFixed)) {
            return false;
        }
        return this.floatValue == ((COSFixed)o).floatValue;
    }

    @Override
    public float floatValue() {
        return this.floatValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.floatValue);
    }

    @Override
    public int intValue() {
        return (int)this.floatValue;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        COSFixed fixed = (COSFixed)object;
        this.precision = fixed.precision;
    }

    public Object saveState() {
        COSFixed result = new COSFixed(this.floatValue, this.precision);
        result.container = this.container.saveStateContainer();
        return result;
    }

    public void setPrecision(int precision) {
        this.precision = (byte)precision;
    }
}

