/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSSwapException;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.logging.Level;

public class COSIndirectObject
extends COSDocumentElement
implements ICOSContainer {
    private static ResourceTracker tracker = new ResourceTracker(){

        protected void basicDispose(Object resource) {
            LogTools.getLogger(COSIndirectObject.class).log(Level.WARNING, "disposed " + resource);
        }
    };
    private static final byte F_DIRTY = 1;
    private static final byte F_FIXED = 2;
    private byte flags = 0;
    private Object object;
    private COSDocument doc;
    private STDocument stDoc;
    private int objectNumber = -1;
    private short generationNumber = (short)-1;
    private short referenceCount = 0;

    public static COSIndirectObject create(COSObject object) {
        COSIndirectObject ref = new COSIndirectObject();
        ref.setDirty(true);
        object.getContainer().register(ref);
        ref.object = object;
        object.basicSetContainer(ref);
        return ref;
    }

    public static COSIndirectObject create(STDocument stDoc, COSObjectKey key) {
        COSIndirectObject ref = new COSIndirectObject();
        ref.setKey(key);
        ref.registerWith(stDoc);
        return ref;
    }

    public static COSIndirectObject create(STDocument stDoc, int objectNumber, int generationNumber) {
        COSIndirectObject ref = new COSIndirectObject();
        ref.setKey(objectNumber, generationNumber);
        ref.registerWith(stDoc);
        return ref;
    }

    protected COSIndirectObject() {
    }

    protected COSIndirectObject(COSIndirectObject indirectObject) {
        this.flags = indirectObject.flags;
        this.doc = indirectObject.doc;
        this.objectNumber = indirectObject.objectNumber;
        this.generationNumber = indirectObject.generationNumber;
        this.stDoc = indirectObject.stDoc;
        this.referenceCount = indirectObject.referenceCount;
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromIndirectObject(this);
    }

    @Override
    protected ICOSContainer addContainer(ICOSContainer container) {
        return this.associate(container, null);
    }

    @Override
    public ICOSContainer associate(ICOSContainer newContainer, COSObject pObject) {
        newContainer.register(this);
        this.referenceCount = (short)(this.referenceCount + 1);
        return this;
    }

    protected COSObject basicSwapIn() {
        try {
            return this.stGetDoc().load(this);
        }
        catch (IOException e) {
            throw new COSSwapException("io error reading object " + this.getKey(), e);
        }
        catch (COSLoadException e) {
            throw new COSSwapException("parse error reading object " + this.getKey(), e);
        }
    }

    @Override
    public COSDocumentElement containable() {
        return this;
    }

    @Override
    public COSDocumentElement containable(COSObject pObject) {
        return this;
    }

    @Override
    protected COSObject copyDeep(Map copied) {
        COSObject result = (COSObject)copied.get(this);
        if (result == null) {
            result = this.dereference().copyDeep(copied);
        }
        return result;
    }

    @Override
    protected COSDocumentElement copyShallowNested() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COSObject dereference() {
        COSObject tempObject;
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            tempObject = this.getObject();
        }
        if (tempObject == null) {
            Object lock = this;
            if (this.stGetDoc() != null) {
                lock = this.stGetDoc().getAccessLock();
            }
            COSIndirectObject cOSIndirectObject2 = lock;
            synchronized (cOSIndirectObject2) {
                tempObject = this.getObject();
                if (tempObject == null) {
                    try {
                        tempObject = this.swapIn();
                        COSIndirectObject cOSIndirectObject3 = this;
                        synchronized (cOSIndirectObject3) {
                            this.setObject(tempObject);
                        }
                    }
                    catch (COSRuntimeException e) {
                        this.setObject(COSNull.create());
                        if (this.doc != null) {
                            this.doc.handleException(e);
                        }
                        throw e;
                    }
                }
            }
        }
        return tempObject;
    }

    @Override
    public ICOSContainer disassociate(ICOSContainer oldContainer, COSObject pObject) {
        this.referenceCount = (short)(this.referenceCount - 1);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        COSObject tempObject;
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            tempObject = this.getObject();
        }
        if (tempObject != null) {
            return true;
        }
        Object lock = this;
        if (this.stGetDoc() != null) {
            lock = this.stGetDoc().getAccessLock();
        }
        COSIndirectObject cOSIndirectObject2 = lock;
        synchronized (cOSIndirectObject2) {
            block9: {
                tempObject = this.getObject();
                if (tempObject == null) break block9;
                return true;
            }
            return this.basicSwapIn() != null;
        }
    }

    @Override
    public COSDocument getDoc() {
        return this.doc;
    }

    public int getGenerationNumber() {
        return this.generationNumber & 0xFFFF;
    }

    public COSObjectKey getKey() {
        COSObjectKey key = null;
        if (this.objectNumber == -1) {
            if (this.stGetDoc() != null) {
                key = this.stGetDoc().createObjectKey();
                this.objectNumber = key.getObjectNumber();
                this.generationNumber = (short)key.getGenerationNumber();
            }
        } else {
            key = new COSObjectKey(this.objectNumber, this.generationNumber);
        }
        return key;
    }

    protected COSObject getObject() {
        if (this.object == null) {
            return null;
        }
        if (this.object instanceof Reference) {
            return (COSObject)((Reference)this.object).get();
        }
        return (COSObject)this.object;
    }

    public int getObjectNumber() {
        if (this.objectNumber == -1 && this.stGetDoc() != null) {
            COSObjectKey key = this.stGetDoc().createObjectKey();
            this.objectNumber = key.getObjectNumber();
            this.generationNumber = (short)key.getGenerationNumber();
        }
        return this.objectNumber;
    }

    @Override
    public void harden(COSObject pObject) {
        if (this.object instanceof Reference) {
            this.flags = (byte)(this.flags | 2);
            this.object = ((Reference)this.object).get();
        }
    }

    public boolean isDirty() {
        return (this.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialState() {
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            return this.object == null;
        }
    }

    @Override
    public boolean isReference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSwapped() {
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            return this.getObject() == null;
        }
    }

    @Override
    public int referenceCount() {
        return this.referenceCount;
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject pObject) {
        return this;
    }

    @Override
    public void register(COSDocumentElement pObject) {
        if (this.doc != null) {
            pObject.registerWith(this.doc);
        }
    }

    @Override
    protected void registerWith(COSDocument newDoc) {
        if (this.doc == null) {
            this.doc = newDoc;
            this.registerWith(newDoc.stGetDoc());
            COSObject tempObject = this.getObject();
            if (tempObject != null) {
                tempObject.registerWith(this.doc);
            }
        } else if (this.doc != newDoc) {
            throw new IllegalStateException("You can not merge objects from different documents");
        }
    }

    public void registerWith(STDocument pSTDoc) {
        this.stDoc = pSTDoc;
        pSTDoc.addObjectReference(this);
        if ((this.flags & 1) != 0) {
            pSTDoc.addChangedReference(this);
        }
    }

    @Override
    protected ICOSContainer removeContainer(ICOSContainer oldContainer) {
        return this.disassociate(oldContainer, null);
    }

    @Override
    public ICOSContainer restoreStateContainer(ICOSContainer container) {
        COSIndirectObject indirectObject = (COSIndirectObject)container;
        this.flags = indirectObject.flags;
        this.referenceCount = indirectObject.referenceCount;
        return this;
    }

    @Override
    public ICOSContainer saveStateContainer() {
        return new COSIndirectObject(this);
    }

    public void setDirty(boolean pDirty) {
        if (pDirty) {
            if ((this.flags & 1) == 0) {
                this.harden(null);
            }
            if (this.stGetDoc() != null) {
                this.stGetDoc().addChangedReference(this);
            }
            this.flags = (byte)(this.flags | 1);
        } else {
            if ((this.flags & 1) != 0) {
                this.soften(null);
            }
            this.flags = (byte)(this.flags ^ 1);
        }
    }

    public void setKey(COSObjectKey key) {
        if (key == null) {
            this.objectNumber = -1;
            this.generationNumber = (short)-1;
        } else {
            this.objectNumber = key.getObjectNumber();
            this.generationNumber = (short)key.getGenerationNumber();
        }
    }

    public void setKey(int objectNumber, int generationNumber) {
        this.objectNumber = objectNumber;
        this.generationNumber = (short)generationNumber;
    }

    protected void setObject(COSObject newObject) {
        this.object = newObject.mayBeSwapped() ? new SoftReference<COSObject>(newObject) : newObject;
        newObject.basicSetContainer(this);
        if (this.doc != null) {
            newObject.registerWith(this.doc);
        }
    }

    @Override
    public void soften(COSObject pObject) {
        if ((this.flags & 2) != 0 && ((COSObject)this.object).mayBeSwapped()) {
            this.flags = (byte)(this.flags ^ 2);
            this.object = new SoftReference<Object>(this.object);
        }
    }

    public final STDocument stGetDoc() {
        return this.stDoc;
    }

    protected COSObject swapIn() {
        COSObject loadedObject = this.basicSwapIn();
        if (loadedObject == null) {
            loadedObject = COSNull.create();
        }
        return loadedObject;
    }

    public String toString() {
        return this.getObjectNumber() + " " + this.getGenerationNumber() + " R" + "->";
    }

    @Override
    public void willChange(COSObject change) {
        if (this.getDoc() != null) {
            this.getDoc().willChange(change);
        }
        this.setDirty(true);
    }
}

